/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.model;

import cloud.altemista.fwk.common.model.AbstractContent;
import cloud.altemista.fwk.common.model.ContentReadable;
import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.springframework.core.io.InputStreamSource;

public class ByteArrayContentReadable
extends AbstractContent
implements ContentReadable,
InputStreamSource,
Serializable {
    private static final long serialVersionUID = -8630688640884191835L;
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private byte[] buffer;

    public ByteArrayContentReadable() {
    }

    public ByteArrayContentReadable(byte[] buffer) {
        this.setBuffer(buffer);
    }

    public ByteArrayContentReadable(byte[] buffer, String contentType, String path) {
        super(contentType, path);
        this.setBuffer(buffer);
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream((byte[])Objects.firstNonNull((Object)this.buffer, (Object)EMPTY_BUFFER));
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer == null ? null : Arrays.copyOf(buffer, buffer.length);
    }
}

