/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.exception;

import cloud.altemista.fwk.common.util.DefensiveUtil;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.Assert;
import org.terasoluna.gfw.common.exception.BusinessException;
import org.terasoluna.gfw.common.message.ResultMessage;
import org.terasoluna.gfw.common.message.ResultMessages;

public abstract class ApplicationException
extends BusinessException
implements MessageSourceResolvable {
    private static final long serialVersionUID = -8127517564433635732L;
    private final String code;
    private final List<Object> arguments;
    private final String defaultMessage;

    protected ApplicationException(String code) {
        this(code, (Object[])null, (String)null);
    }

    protected ApplicationException(String code, String defaultMessage) {
        this(code, (Object[])null, defaultMessage);
    }

    protected ApplicationException(String code, Object ... arguments) {
        this(code, arguments, (String)null);
    }

    protected ApplicationException(String code, Throwable cause) {
        this(code, (Object[])null, cause);
    }

    protected ApplicationException(String code, String defaultMessage, Throwable cause) {
        this(code, null, defaultMessage, cause);
    }

    protected ApplicationException(String code, Object[] arguments, Throwable cause) {
        this(code, arguments, null, cause);
    }

    protected ApplicationException(String code, Object[] arguments, String defaultMessage) {
        super(defaultMessage != null ? defaultMessage : code);
        Assert.notNull((Object)code, (String)"code must not be null");
        this.code = code;
        this.arguments = DefensiveUtil.unmodifiableList(arguments);
        this.defaultMessage = defaultMessage;
    }

    protected ApplicationException(String code, Object[] arguments, String defaultMessage, Throwable cause) {
        super(ResultMessages.error().add(ResultMessage.fromText((String)(defaultMessage != null ? defaultMessage : code))), cause);
        Assert.notNull((Object)code, (String)"code must not be null");
        this.code = code;
        this.arguments = DefensiveUtil.unmodifiableList(arguments);
        this.defaultMessage = defaultMessage;
    }

    protected String getCode() {
        return this.code;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getCode());
        if (!CollectionUtils.isEmpty(this.arguments)) {
            sb.append("; ").append(StringUtils.join(this.arguments, (String)","));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDefaultMessage())) {
            sb.append("; ").append(this.getDefaultMessage());
        }
        return sb.append("]").toString();
    }

    public String[] getCodes() {
        return new String[]{this.getCode()};
    }

    public Object[] getArguments() {
        return this.arguments == null ? null : this.arguments.toArray(new Object[this.arguments.size()]);
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}

