/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public final class ReflectionUtil {
    private static final Map<String, Method> METHOD_CACHE = new ConcurrentReferenceHashMap(256);

    private ReflectionUtil() {
    }

    public static Method getMethod(String pClassName, String pName, Class<?> ... parameterTypes) {
        String name;
        if (StringUtils.isBlank((CharSequence)pClassName) || StringUtils.isBlank((CharSequence)pName)) {
            return null;
        }
        String className = StringUtils.trim((String)pClassName);
        String key = String.format("%s.%S", className, name = StringUtils.trim((String)pName));
        if (METHOD_CACHE.containsKey(key)) {
            return METHOD_CACHE.get(key);
        }
        try {
            Class lClass = ClassUtils.getClass((String)className, (boolean)false);
            Method method = lClass.getMethod(name, parameterTypes);
            METHOD_CACHE.put(key, method);
            return method;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static Method getMethod(Class<?> pClass, String pName, Class<?> ... parameterTypes) {
        if (pClass == null || StringUtils.isBlank((CharSequence)pName)) {
            return null;
        }
        String name = StringUtils.trim((String)pName);
        String key = String.format("%s.%S", pClass.getName(), name);
        if (METHOD_CACHE.containsKey(key)) {
            return METHOD_CACHE.get(key);
        }
        try {
            Method method = pClass.getMethod(name, parameterTypes);
            METHOD_CACHE.put(key, method);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static void clearCache() {
        METHOD_CACHE.clear();
    }

    public static class WithoutAnyModifiersFieldFilter
    implements ReflectionUtils.FieldFilter {
        private int modifiers;

        public WithoutAnyModifiersFieldFilter(int modifiers) {
            this.modifiers = modifiers;
        }

        public boolean matches(Field field) {
            return (field.getModifiers() & this.modifiers) == 0;
        }
    }

    public static class WithAnyModifiersFieldFilter
    implements ReflectionUtils.FieldFilter {
        private int modifiers;

        public WithAnyModifiersFieldFilter(int modifiers) {
            this.modifiers = modifiers;
        }

        public boolean matches(Field field) {
            return (field.getModifiers() & this.modifiers) != 0;
        }
    }

    public static class WithAllModifiersFieldFilter
    implements ReflectionUtils.FieldFilter {
        private int modifiers;

        public WithAllModifiersFieldFilter(int modifiers) {
            this.modifiers = modifiers;
        }

        public boolean matches(Field field) {
            return (field.getModifiers() & this.modifiers) == this.modifiers;
        }
    }
}

