/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public final class MatchUtil {
    private static final PathMatcher PATH_MATCHER = new AntPathMatcher(".");
    private static final Pattern PATTERN_IMPLEMENTS = Pattern.compile("^implements\\((.*)\\)$");
    private static final int IMPLEMENTS_NESTED_PATTERN_GROUP = 1;

    private MatchUtil() {
    }

    public static boolean match(String pattern, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            return false;
        }
        Matcher implementsMatcher = PATTERN_IMPLEMENTS.matcher(pattern);
        if (implementsMatcher.matches()) {
            String nestedPattern = implementsMatcher.group(1);
            return StringUtils.isNotEmpty((CharSequence)nestedPattern) && MatchUtil.interfacesMatch(nestedPattern, clazz);
        }
        return MatchUtil.classNameMatches(pattern, clazz.getName());
    }

    public static boolean match(String pattern, String className) {
        if (StringUtils.isEmpty((CharSequence)className)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            return false;
        }
        Matcher implementsMatcher = PATTERN_IMPLEMENTS.matcher(pattern);
        if (implementsMatcher.matches()) {
            String nestedPattern = implementsMatcher.group(1);
            if (StringUtils.isEmpty((CharSequence)nestedPattern)) {
                return false;
            }
            Class clazz = null;
            try {
                clazz = ClassUtils.getClass((String)className);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return MatchUtil.interfacesMatch(nestedPattern, clazz);
        }
        return MatchUtil.classNameMatches(pattern, className);
    }

    public static StackTraceElement stackTraceElementMatching(String ... patterns) {
        if (ArrayUtils.isEmpty((Object[])patterns)) {
            return null;
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int n = stackTraceElements.length;
        int index = Integer.MAX_VALUE;
        block0: for (String pattern : patterns) {
            if (StringUtils.isEmpty((CharSequence)pattern)) continue;
            Matcher implementsMatcher = PATTERN_IMPLEMENTS.matcher(pattern);
            if (implementsMatcher.matches()) {
                String nestedPattern = implementsMatcher.group(1);
                if (StringUtils.isEmpty((CharSequence)nestedPattern)) continue;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement element = stackTraceElements[i];
                    if (!MatchUtil.interfacesMatch(nestedPattern, element.getClass())) continue;
                    index = Math.min(i, index);
                    continue block0;
                }
                continue;
            }
            for (int i = 0; i < n; ++i) {
                StackTraceElement element = stackTraceElements[i];
                if (!MatchUtil.classNameMatches(pattern, element.getClassName())) continue;
                index = Math.min(i, index);
                continue block0;
            }
        }
        if (index < n) {
            return stackTraceElements[index];
        }
        return null;
    }

    private static boolean classNameMatches(String pattern, String className) {
        return PATH_MATCHER.match(pattern, className);
    }

    private static boolean interfacesMatch(String nestedPattern, Class<?> clazz) {
        for (Class<?> interf : clazz.getInterfaces()) {
            if (!MatchUtil.classNameMatches(nestedPattern, interf.getName())) continue;
            return true;
        }
        return false;
    }
}

