/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.model;

import cloud.altemista.fwk.common.model.ContentReadable;
import cloud.altemista.fwk.common.util.ResourceUtil;
import com.google.common.base.Objects;
import java.io.InputStream;
import java.io.Serializable;
import org.springframework.core.io.InputStreamSource;

public class ResourceContentReadable
implements ContentReadable,
InputStreamSource,
Serializable {
    private static final long serialVersionUID = 1678866397751737044L;
    private String resourceLocation;
    private String contentType;

    public ResourceContentReadable() {
    }

    public ResourceContentReadable(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public ResourceContentReadable(String resourceLocation, String contentType) {
        this.resourceLocation = resourceLocation;
        this.contentType = contentType;
    }

    @Override
    public InputStream getInputStream() {
        return ResourceUtil.getInputStream(this.resourceLocation);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getPath() {
        return this.resourceLocation;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("contentType", (Object)this.contentType).add("resourceLocation", (Object)this.resourceLocation).toString();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }
}

