/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.exception;

import cloud.altemista.fwk.common.util.DefensiveUtil;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.terasoluna.gfw.common.exception.SystemException;

public abstract class FrameworkException
extends SystemException
implements MessageSourceResolvable {
    private static final long serialVersionUID = -5133582921534121794L;
    private final List<Object> arguments;
    private final String defaultMessage;

    protected FrameworkException(String code) {
        this(code, (Object[])null, (String)null);
    }

    protected FrameworkException(String code, String defaultMessage) {
        this(code, (Object[])null, defaultMessage);
    }

    protected FrameworkException(String code, Object ... arguments) {
        this(code, arguments, (String)null);
    }

    protected FrameworkException(String code, Throwable cause) {
        this(code, (Object[])null, cause);
    }

    protected FrameworkException(String code, String defaultMessage, Throwable cause) {
        this(code, null, defaultMessage, cause);
    }

    protected FrameworkException(String code, Object[] arguments, Throwable cause) {
        this(code, arguments, null, cause);
    }

    protected FrameworkException(String code, Object[] arguments, String defaultMessage) {
        super(code, defaultMessage);
        Assert.notNull((Object)code, (String)"code must not be null");
        this.arguments = DefensiveUtil.unmodifiableList(arguments);
        this.defaultMessage = defaultMessage;
    }

    protected FrameworkException(String code, Object[] arguments, String defaultMessage, Throwable cause) {
        super(code, defaultMessage, cause);
        Assert.notNull((Object)code, (String)"code must not be null");
        this.arguments = DefensiveUtil.unmodifiableList(arguments);
        this.defaultMessage = defaultMessage;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getCode());
        if (!ObjectUtils.isEmpty((Object[])this.getArguments())) {
            sb.append("; ").append(ArrayUtils.toString((Object)this.getArguments()));
        }
        if (StringUtils.hasText((String)this.getDefaultMessage())) {
            sb.append("; ").append(this.getDefaultMessage());
        }
        return sb.append("]").toString();
    }

    public String[] getCodes() {
        return new String[]{this.getCode()};
    }

    public Object[] getArguments() {
        return this.arguments == null ? null : this.arguments.toArray(new Object[this.arguments.size()]);
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public String getCode() {
        return this.prepareCode(super.getCode());
    }

    protected String prepareCode(String code) {
        return String.format("e.%s.%s", ((Object)((Object)this)).getClass().getPackage().getName(), code);
    }
}

