/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.connection.util;

import cloud.altemista.fwk.common.connection.model.ProxyBean;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public final class ThreadLocalProxySelector
extends ProxySelector {
    private static final ThreadLocalProxySelector INSTANCE = new ThreadLocalProxySelector();
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    private static ThreadLocal<ProxyBean> threadLocalProxy = new ThreadLocal();
    private static ProxySelector defaultProxySelector;

    private ThreadLocalProxySelector() {
    }

    public static void resetProxy() {
        threadLocalProxy.remove();
        if (defaultProxySelector != null) {
            ProxySelector.setDefault(defaultProxySelector);
        }
        defaultProxySelector = null;
    }

    public static void setProxy(ProxyBean proxyBean) {
        threadLocalProxy.set(proxyBean);
        if (defaultProxySelector == null) {
            defaultProxySelector = ProxySelector.getDefault();
        }
        ProxySelector.setDefault(INSTANCE);
    }

    @Override
    public List<Proxy> select(URI uri) {
        Assert.notNull((Object)uri);
        ProxyBean proxyBean = threadLocalProxy.get();
        if (proxyBean == null) {
            if (defaultProxySelector != null) {
                return defaultProxySelector.select(uri);
            }
            return NO_PROXY_LIST;
        }
        String scheme = uri.getScheme();
        if (HTTP_SCHEME.equals(scheme) || HTTPS_SCHEME.equals(scheme)) {
            this.setDefaultAuthenticator();
            return Collections.singletonList(this.asProxy(Proxy.Type.HTTP));
        }
        return this.defaultProxy(uri);
    }

    private void setDefaultAuthenticator() {
        ProxyBean proxyBean = threadLocalProxy.get();
        if (proxyBean.getUsername() == null) {
            return;
        }
        Authenticator.setDefault(new ProxyAuthenticator(this.asPasswordAuthentication()));
    }

    private List<Proxy> defaultProxy(URI uri) {
        if (defaultProxySelector != null) {
            return defaultProxySelector.select(uri);
        }
        return NO_PROXY_LIST;
    }

    private Proxy asProxy(Proxy.Type type) {
        ProxyBean proxyBean = threadLocalProxy.get();
        return new Proxy(type, new InetSocketAddress(proxyBean.getHostname(), proxyBean.getPort()));
    }

    private PasswordAuthentication asPasswordAuthentication() {
        ProxyBean proxyBean = threadLocalProxy.get();
        if (proxyBean.getUsername() == null || proxyBean.getPassword() == null) {
            return null;
        }
        return new PasswordAuthentication(proxyBean.getUsername(), proxyBean.getPassword().toCharArray());
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    private static final class ProxyAuthenticator
    extends Authenticator {
        private PasswordAuthentication passwordAuthentication;

        public ProxyAuthenticator(PasswordAuthentication passwordAuthentication) {
            this.passwordAuthentication = passwordAuthentication;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                return this.passwordAuthentication;
            }
            return super.getPasswordAuthentication();
        }
    }
}

