/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.common.connection.util;

import cloud.altemista.fwk.common.connection.exception.ConnectionException;
import cloud.altemista.fwk.common.cryptography.model.KeyStoreBean;
import cloud.altemista.fwk.common.cryptography.util.KeyStoreUtil;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;

public final class SSLSocketFactoryUtil {
    private SSLSocketFactoryUtil() {
    }

    public static void set(KeyStoreBean keyStore, KeyStoreBean trustStore) {
        if (keyStore == null) {
            throw new ConnectionException("no_keystore");
        }
        if (trustStore == null) {
            throw new ConnectionException("no_truststore");
        }
        try {
            KeyManager[] keyMgr = KeyStoreUtil.getKeyManagers((KeyStoreBean)keyStore);
            TrustManager[] trustMgr = KeyStoreUtil.getTrustManagers((KeyStoreBean)trustStore);
            SSLContext sslCtx = SSLContext.getInstance("SSL");
            sslCtx.init(keyMgr, trustMgr, null);
            SSLSocketFactory sslSocketFactory = sslCtx.getSocketFactory();
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConnectionException("ssl_socket_factory", e);
        }
        catch (KeyManagementException e) {
            throw new ConnectionException("ssl_socket_factory", e);
        }
    }
}

