/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.core.batch.model;

import cloud.altemista.fwk.common.util.DefensiveUtil;
import java.io.Serializable;
import java.util.Date;

public abstract class BatchParameter<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -7366438395109555890L;
    private final String name;
    private final T value;
    private final boolean identifier;

    private BatchParameter(String name, T value, boolean identifier) {
        this.name = name;
        this.value = value;
        this.identifier = identifier;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isIdentifier() {
        return this.identifier;
    }

    /* synthetic */ BatchParameter(String x0, Serializable x1, boolean x2, 1 x3) {
        this(x0, x1, x2);
    }

    public static final class DateParameter
    extends BatchParameter<Date> {
        private static final long serialVersionUID = 7522992242601967382L;

        public DateParameter(String name, Date value, boolean identifier) {
            super(name, DefensiveUtil.copyOf((Date)value), identifier, null);
        }

        @Override
        public Date getValue() {
            return DefensiveUtil.copyOf((Date)((Date)super.getValue()));
        }
    }

    public static final class BooleanParameter
    extends BatchParameter<Boolean> {
        private static final long serialVersionUID = -5530415596327771644L;

        public BooleanParameter(String name, Boolean value, boolean identifier) {
            super(name, value, identifier, null);
        }
    }

    public static final class DoubleParameter
    extends BatchParameter<Double> {
        private static final long serialVersionUID = -293064291043948026L;

        public DoubleParameter(String name, Double value, boolean identifier) {
            super(name, value, identifier, null);
        }
    }

    public static final class LongParameter
    extends BatchParameter<Long> {
        private static final long serialVersionUID = 6328787857259101793L;

        public LongParameter(String name, Long value, boolean identifier) {
            super(name, value, identifier, null);
        }
    }

    public static final class StringParameter
    extends BatchParameter<String> {
        private static final long serialVersionUID = 6038241325059915539L;

        public StringParameter(String name, String value, boolean identifier) {
            super(name, (Serializable)((Object)value), identifier, null);
        }
    }
}

