/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.batch.spring.impl;

import cloud.altemista.fwk.batch.spring.model.BatchJobExecution;
import cloud.altemista.fwk.common.util.CollectionUtil;
import cloud.altemista.fwk.core.batch.BatchService;
import cloud.altemista.fwk.core.batch.exception.BatchException;
import cloud.altemista.fwk.core.batch.model.BatchParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchServiceImpl
implements BatchService {
    @Autowired
    private JobRegistry jobRegistry;
    @Autowired
    private JobOperator jobOperator;
    @Autowired
    private JobExplorer jobExplorer;
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private JobLauncher jobLauncher;

    public int countJobs() {
        return this.jobRegistry.getJobNames().size();
    }

    public List<String> listJobs(int start, int count) {
        return CollectionUtil.page((Collection)this.jobRegistry.getJobNames(), (int)start, (int)count);
    }

    public boolean isLaunchable(String jobName) {
        return this.existsJobQuietly(jobName);
    }

    public Long launch(String jobName, BatchParameter<?> ... parameters) {
        BatchStatus status;
        Job job = this.getJobQuietly(jobName);
        if (job == null) {
            return null;
        }
        JobParameters jobParameters = this.parametersFromModel(parameters);
        JobExecution lastJobExecution = this.jobRepository.getLastJobExecution(jobName, jobParameters);
        boolean restart = false;
        if (lastJobExecution != null && (status = lastJobExecution.getStatus()).isUnsuccessful() && status != BatchStatus.ABANDONED) {
            restart = true;
        }
        if (!restart && job.getJobParametersIncrementer() != null) {
            jobParameters = job.getJobParametersIncrementer().getNext(jobParameters);
        }
        try {
            JobExecution execution = this.jobLauncher.run(job, jobParameters);
            return execution.getId();
        }
        catch (JobExecutionException e) {
            this.handleJobExecutionException(jobName, null, e);
            throw new IllegalStateException("Should never get here");
        }
    }

    public boolean isLaunchableNextInstance(String jobName) {
        Job job = this.getJobQuietly(jobName);
        return job != null && job.getJobParametersIncrementer() != null;
    }

    public Long launchNextInstance(String jobName) {
        if (!this.isLaunchableNextInstance(jobName)) {
            return null;
        }
        try {
            return this.jobOperator.startNextInstance(jobName);
        }
        catch (JobExecutionException e) {
            this.handleJobExecutionException(jobName, null, e);
            throw new IllegalStateException("Should never get here");
        }
    }

    public int countJobInstances(String jobName) {
        if (!this.existsJobQuietly(jobName)) {
            return 0;
        }
        try {
            return this.jobExplorer.getJobInstanceCount(jobName);
        }
        catch (NoSuchJobException e) {
            this.handleJobExecutionException(jobName, null, (JobExecutionException)((Object)e));
            throw new IllegalStateException("Should never get here");
        }
    }

    public List<Long> listJobInstances(String jobName, int start, int count) {
        if (!this.existsJobQuietly(jobName)) {
            return Collections.emptyList();
        }
        List jobInstances = this.jobExplorer.getJobInstances(jobName, start, count);
        ArrayList<Long> list = new ArrayList<Long>();
        for (JobInstance instance : jobInstances) {
            list.add(instance.getInstanceId());
        }
        return list;
    }

    public List<javax.batch.runtime.JobExecution> getExecutions(long instanceId) {
        JobInstance instance = this.jobExplorer.getJobInstance(Long.valueOf(instanceId));
        if (instance == null) {
            return Collections.emptyList();
        }
        List executions = this.jobExplorer.getJobExecutions(instance);
        return this.executionsToModel(executions);
    }

    public List<javax.batch.runtime.JobExecution> getRunningExecutions(String jobname) {
        Set executions = this.jobExplorer.findRunningJobExecutions(jobname);
        return this.executionsToModel(executions);
    }

    public List<BatchParameter<?>> getParameters(long executionId) {
        JobExecution jobExecution = this.jobExplorer.getJobExecution(Long.valueOf(executionId));
        if (jobExecution == null) {
            throw new BatchException("execution_unknown");
        }
        return this.parametersToModel(jobExecution.getJobParameters());
    }

    public boolean stop(long executionId) {
        try {
            return this.jobOperator.stop(executionId);
        }
        catch (NoSuchJobExecutionException e) {
            return false;
        }
        catch (JobExecutionNotRunningException e) {
            return false;
        }
    }

    public Long restart(long executionId) {
        try {
            return this.jobOperator.restart(executionId);
        }
        catch (NoSuchJobExecutionException e) {
            return null;
        }
        catch (JobInstanceAlreadyCompleteException e) {
            return null;
        }
        catch (UnexpectedJobExecutionException e) {
            if (e.getCause() instanceof JobExecutionAlreadyRunningException) {
                return null;
            }
            throw e;
        }
        catch (JobExecutionException e) {
            this.handleJobExecutionException(null, executionId, e);
            throw new IllegalStateException("Should never get here");
        }
    }

    public javax.batch.runtime.JobExecution abandon(long executionId) {
        try {
            return this.executionToMdoel(this.jobOperator.abandon(executionId));
        }
        catch (NoSuchJobExecutionException e) {
            return null;
        }
        catch (JobExecutionAlreadyRunningException e) {
            return null;
        }
    }

    private boolean existsJobQuietly(String jobName) {
        if (StringUtils.isEmpty((CharSequence)jobName)) {
            return false;
        }
        return this.jobRegistry.getJobNames().contains(jobName);
    }

    private Job getJobQuietly(String jobName) {
        if (StringUtils.isEmpty((CharSequence)jobName)) {
            return null;
        }
        try {
            return this.jobRegistry.getJob(jobName);
        }
        catch (NoSuchJobException e) {
            return null;
        }
    }

    private void handleJobExecutionException(String jobName, Long executionId, JobExecutionException e) {
        if (e instanceof NoSuchJobException) {
            throw new BatchException("job_unknown", new Object[]{jobName}, (Throwable)e);
        }
        if (e instanceof NoSuchJobExecutionException) {
            throw new BatchException("execution_unknown", new Object[]{executionId}, (Throwable)e);
        }
        throw new BatchException("invalid_state", new Object[]{jobName, executionId}, (Throwable)e);
    }

    private List<javax.batch.runtime.JobExecution> executionsToModel(Collection<JobExecution> executions) {
        if (executions == null || executions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<javax.batch.runtime.JobExecution> list = new ArrayList<javax.batch.runtime.JobExecution>();
        for (JobExecution execution : executions) {
            list.add(this.executionToMdoel(execution));
        }
        return list;
    }

    private javax.batch.runtime.JobExecution executionToMdoel(JobExecution execution) {
        if (execution == null) {
            return null;
        }
        return new BatchJobExecution(execution);
    }

    private JobParameters parametersFromModel(BatchParameter<?> ... parameters) {
        JobParametersBuilder builder = new JobParametersBuilder();
        if (parameters != null) {
            for (BatchParameter<?> parameter : parameters) {
                Object value;
                if (parameter instanceof BatchParameter.StringParameter) {
                    value = (String)((Object)((BatchParameter.StringParameter)parameter).getValue());
                    builder.addString(parameter.getName(), (String)value, parameter.isIdentifier());
                    continue;
                }
                if (parameter instanceof BatchParameter.DateParameter) {
                    value = ((BatchParameter.DateParameter)parameter).getValue();
                    builder.addDate(parameter.getName(), (Date)value, parameter.isIdentifier());
                    continue;
                }
                if (parameter instanceof BatchParameter.LongParameter) {
                    value = (Long)((BatchParameter.LongParameter)parameter).getValue();
                    builder.addLong(parameter.getName(), (Long)value, parameter.isIdentifier());
                    continue;
                }
                if (parameter instanceof BatchParameter.DoubleParameter) {
                    value = (Double)((BatchParameter.DoubleParameter)parameter).getValue();
                    builder.addDouble(parameter.getName(), (Double)value, parameter.isIdentifier());
                    continue;
                }
                if (!(parameter instanceof BatchParameter.BooleanParameter)) continue;
                value = BooleanUtils.toStringTrueFalse((Boolean)((Boolean)((BatchParameter.BooleanParameter)parameter).getValue()));
                builder.addString(parameter.getName(), (String)value, parameter.isIdentifier());
            }
        }
        return builder.toJobParameters();
    }

    private List<BatchParameter<?>> parametersToModel(JobParameters parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        for (Map.Entry entry : parameters.getParameters().entrySet()) {
            list.add(this.parameterToModel((String)entry.getKey(), (JobParameter)entry.getValue()));
        }
        return list;
    }

    private BatchParameter<?> parameterToModel(String name, JobParameter parameter) {
        if (parameter == null) {
            return null;
        }
        switch (parameter.getType()) {
            case STRING: {
                return new BatchParameter.StringParameter(name, (String)parameter.getValue(), parameter.isIdentifying());
            }
            case DATE: {
                return new BatchParameter.DateParameter(name, (Date)parameter.getValue(), parameter.isIdentifying());
            }
            case LONG: {
                return new BatchParameter.LongParameter(name, (Long)parameter.getValue(), parameter.isIdentifying());
            }
            case DOUBLE: {
                return new BatchParameter.DoubleParameter(name, (Double)parameter.getValue(), parameter.isIdentifying());
            }
        }
        throw new IllegalStateException("Should never get here");
    }
}

