/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.batch.spring.model;

import cloud.altemista.fwk.common.util.DefensiveUtil;
import java.util.Date;
import java.util.EnumMap;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.util.Assert;

public class BatchJobExecution
implements JobExecution {
    private static final EnumMap<org.springframework.batch.core.BatchStatus, BatchStatus> STATUSES = new EnumMap(org.springframework.batch.core.BatchStatus.class);
    private final org.springframework.batch.core.JobExecution job;

    public BatchJobExecution(org.springframework.batch.core.JobExecution job) {
        Assert.notNull((Object)job, (String)"The JobExecution is required");
        this.job = job;
    }

    public long getExecutionId() {
        return this.job.getId();
    }

    public String getJobName() {
        JobInstance instance = this.job.getJobInstance();
        if (instance == null) {
            return null;
        }
        return instance.getJobName();
    }

    public BatchStatus getBatchStatus() {
        return STATUSES.get(this.job.getStatus());
    }

    public Date getStartTime() {
        return DefensiveUtil.copyOf((Date)this.job.getStartTime());
    }

    public Date getEndTime() {
        return DefensiveUtil.copyOf((Date)this.job.getEndTime());
    }

    public String getExitStatus() {
        ExitStatus exitStatus = this.job.getExitStatus();
        if (exitStatus == null) {
            return null;
        }
        return exitStatus.getExitCode();
    }

    public Date getCreateTime() {
        return DefensiveUtil.copyOf((Date)this.job.getCreateTime());
    }

    public Date getLastUpdatedTime() {
        return DefensiveUtil.copyOf((Date)this.job.getLastUpdated());
    }

    public Properties getJobParameters() {
        JobParameters parameters = this.job.getJobParameters();
        if (parameters == null) {
            return null;
        }
        return parameters.toProperties();
    }

    static {
        STATUSES.put(org.springframework.batch.core.BatchStatus.COMPLETED, BatchStatus.COMPLETED);
        STATUSES.put(org.springframework.batch.core.BatchStatus.STARTING, BatchStatus.STARTING);
        STATUSES.put(org.springframework.batch.core.BatchStatus.STARTED, BatchStatus.STARTED);
        STATUSES.put(org.springframework.batch.core.BatchStatus.STOPPING, BatchStatus.STOPPING);
        STATUSES.put(org.springframework.batch.core.BatchStatus.STOPPED, BatchStatus.STOPPED);
        STATUSES.put(org.springframework.batch.core.BatchStatus.FAILED, BatchStatus.FAILED);
        STATUSES.put(org.springframework.batch.core.BatchStatus.ABANDONED, BatchStatus.ABANDONED);
        STATUSES.put(org.springframework.batch.core.BatchStatus.UNKNOWN, null);
    }
}

