/*
 * Decompiled with CFR 0.152.
 */
package cloud.altemista.fwk.amazon;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AmazonS3Config {
    @Value(value="${aws.access.key.id}")
    private String awsKeyId;
    @Value(value="${aws.access.key.secret}")
    private String awsKeySecret;
    @Value(value="${aws.region}")
    private String awsRegion;
    @Value(value="${aws.s3.audio.bucket}")
    private String awsS3AudioBucket;

    @Bean(name={"awsKeyId"})
    public String getAWSKeyId() {
        return this.awsKeyId;
    }

    @Bean(name={"awsKeySecret"})
    public String getAWSKeySecret() {
        return this.awsKeySecret;
    }

    @Bean(name={"awsRegion"})
    public Region getAWSPollyRegion() {
        return Region.getRegion((Regions)Regions.fromName((String)this.awsRegion));
    }

    @Bean(name={"awsCredentialsProvider"})
    public AWSCredentialsProvider getAWSCredentials() {
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.awsKeyId, this.awsKeySecret);
        return new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
    }

    @Bean(name={"awsS3AudioBucket"})
    public String getAWSS3AudioBucket() {
        return this.awsS3AudioBucket;
    }
}

