/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.properties;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.file.JarUtil;
import cloud.agileframework.common.util.files.SupportEnum;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.string.StringUtil;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yaml.snakeyaml.Yaml;

public class PropertiesUtil {
    private static final String CLASS = ".class";
    private static final String CLASSES_DIR_SPLIT = "/";
    private static final String DIR_SPLIT = "\\";
    private static final String PROPERTIES_KEY_SPLIT = ".";
    private static final String[] overrideConfig = new String[]{"application"};
    private static Log log = LogFactory.getLog(PropertiesUtil.class);
    private static Properties properties = new Properties();
    private static Set<String> fileNames = Sets.newHashSet();

    private static void parsePlaceholder() {
        if (properties == null) {
            return;
        }
        for (Map.Entry<Object, Object> v : properties.entrySet()) {
            if (!(v.getValue() instanceof String)) continue;
            properties.setProperty(String.valueOf(v.getKey()), StringUtil.parsingPlaceholder("${", "}", String.valueOf(v.getValue()), properties));
        }
    }

    private static void readDir() {
        HashSet fileNames = Sets.newHashSet();
        HashSet overrideConfigFileNames = Sets.newHashSet();
        try {
            Collections.list(PropertiesUtil.class.getClassLoader().getResources("")).forEach(url -> {
                try {
                    PropertiesUtil.readDir(fileNames, new File(URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8.name())));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            });
            String classPath = PropertiesUtil.class.getResource(CLASSES_DIR_SPLIT).getPath();
            fileNames.stream().filter(PropertiesUtil.filterOverrideConfigName(overrideConfigFileNames)).sorted(PropertiesUtil.getStringComparator()).forEach(PropertiesUtil.toRead(classPath));
            overrideConfigFileNames.stream().sorted(PropertiesUtil.getStringComparator()).forEach(PropertiesUtil.toRead(classPath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Consumer<String> toRead(String classPath) {
        return fileName -> {
            try {
                PropertiesUtil.read(fileName.replace(classPath, "").replace(DIR_SPLIT, CLASSES_DIR_SPLIT), new FileInputStream(new File((String)fileName)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        };
    }

    private static Comparator<String> getStringComparator() {
        return (a, b) -> {
            String regex = "[\\\\/]";
            int s = b.split("[\\\\/]").length - a.split("[\\\\/]").length;
            if (s == 0) {
                s = a.compareTo((String)b);
            }
            return s;
        };
    }

    private static Predicate<String> filterOverrideConfigName(Set<String> overrideConfigFileNames) {
        return name -> {
            for (String overrideConfigName : overrideConfig) {
                if (!name.contains(overrideConfigName + PROPERTIES_KEY_SPLIT)) continue;
                overrideConfigFileNames.add((String)name);
                return false;
            }
            return true;
        };
    }

    private static void readDir(Set<String> fileNames, File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (file.isFile() && !file.getName().endsWith(CLASS)) {
                    try {
                        fileNames.add(URLDecoder.decode(file.toURI().getPath(), StandardCharsets.UTF_8.name()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!file.isDirectory()) continue;
                PropertiesUtil.readDir(fileNames, file);
            }
        }
    }

    public static void readJar(String packagePath) {
        Set<String> resourceNames = JarUtil.getFile(packagePath, false, CLASS);
        HashSet overrideConfigFileNames = Sets.newHashSet();
        resourceNames.stream().filter(PropertiesUtil.filterOverrideConfigName(overrideConfigFileNames)).sorted(PropertiesUtil.getStringComparator()).forEach(resourceName -> PropertiesUtil.read(resourceName, PropertiesUtil.class.getResourceAsStream((String)resourceName)));
        overrideConfigFileNames.stream().sorted(PropertiesUtil.getStringComparator()).forEach(resourceName -> PropertiesUtil.read(resourceName, PropertiesUtil.class.getResourceAsStream((String)resourceName)));
    }

    public static void read(String fileName, InputStream inputStream) {
        if (fileName == null || inputStream == null) {
            return;
        }
        try {
            if (fileName.endsWith(SupportEnum.properties.name())) {
                PropertiesUtil.readProperties(inputStream);
            } else if (fileName.endsWith(SupportEnum.yml.name()) || fileName.endsWith(SupportEnum.yaml.name())) {
                PropertiesUtil.readYml(inputStream);
            }
            if (!fileName.endsWith(CLASS)) {
                if (!fileName.startsWith(CLASSES_DIR_SPLIT)) {
                    fileName = CLASSES_DIR_SPLIT + fileName;
                }
                fileNames.add(fileName);
            }
            System.out.println(fileName);
            if (log.isDebugEnabled()) {
                log.debug((Object)fileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)String.format("read file(%s) to properties is error", fileName), (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void readEnv() {
        PropertiesUtil.readProperties(System.getProperties());
        PropertiesUtil.readProperties(System.getenv());
    }

    private static void readProperties(InputStream in) throws IOException {
        properties.load(in);
    }

    private static void readProperties(Map<?, ?> map) {
        if (map == null) {
            return;
        }
        map.forEach((key, value) -> {
            try {
                properties.setProperty(key.toString(), String.valueOf(value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static void readYml(InputStream in) {
        Yaml yaml = new Yaml();
        Map dataMap = (Map)yaml.load(in);
        PropertiesUtil.ymlToMap(properties, dataMap, null);
    }

    private static void ymlToMap(Map<Object, Object> allMap, Map<String, Object> map, String parentKey) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String currentKey = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                if (parentKey == null) {
                    PropertiesUtil.ymlToMap(allMap, (Map)value, currentKey.toString());
                    continue;
                }
                PropertiesUtil.ymlToMap(allMap, (Map)value, parentKey + PROPERTIES_KEY_SPLIT + currentKey.toString());
                continue;
            }
            if (value == null) continue;
            if (parentKey == null) {
                allMap.put(currentKey.toString(), value.toString());
            }
            if (parentKey == null) continue;
            allMap.put(parentKey + PROPERTIES_KEY_SPLIT + currentKey.toString(), value.toString());
        }
    }

    public static Properties getProperties() {
        return properties;
    }

    public static Set<String> getFileNames() {
        return fileNames;
    }

    public static void setProperties(String key, String value) {
        if (value == null) {
            return;
        }
        properties.setProperty(key, value);
    }

    public static void appendProperties(String key, String value) {
        String v = properties.getProperty(key);
        if (v == null) {
            properties.setProperty(key, value);
        } else {
            properties.setProperty(key, v + value);
        }
    }

    public static String getProperty(String key) {
        Object value = properties.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String getProperty(String key, String defaultValue) {
        String value = PropertiesUtil.getProperty(key);
        if (!ObjectUtil.isEmpty((Object)value)) {
            return value.toString();
        }
        return defaultValue;
    }

    public static Properties getPropertyByPrefix(String prefix) {
        Properties properties = new Properties();
        Set<String> propertyNames = PropertiesUtil.getProperties().stringPropertyNames();
        for (String name : propertyNames) {
            if (!name.startsWith(prefix)) continue;
            properties.put(name, PropertiesUtil.getProperties().get(name));
        }
        return properties;
    }

    public static <T> T getProperty(String key, Class<T> clazz) {
        return ObjectUtil.to((Object)PropertiesUtil.getProperty(key), new TypeReference(clazz));
    }

    public static <T> T getProperty(String var1, Class<T> var2, String defaultValue) {
        return ObjectUtil.to((Object)PropertiesUtil.getProperty(var1, defaultValue), new TypeReference(var2));
    }

    static {
        PropertiesUtil.readJar("com.agile");
        PropertiesUtil.readDir();
        PropertiesUtil.readEnv();
        PropertiesUtil.parsePlaceholder();
    }
}

