/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.http;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.http.NotFoundRequestMethodException;
import cloud.agileframework.common.util.http.Protocol;
import cloud.agileframework.common.util.http.RequestMethod;
import cloud.agileframework.common.util.map.MapUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private static final String HTTPS = "https://";
    private static final String HTTP = "http://";
    private static final String CONTENT_TYPE = "Content-type";
    private static final String CONNECTION = "Connection";

    public static String get(String url) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Get, url, null, null);
    }

    public static String get(String url, Object header) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Get, url, header, null);
    }

    public static String get(String url, Object header, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Get, url, header, param);
    }

    public static String post(String url) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Post, url, null, null);
    }

    public static String post(String url, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Post, url, null, param);
    }

    public static String post(String url, Object header, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Post, url, header, param);
    }

    public static String put(String url) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Put, url, null, null);
    }

    public static String put(String url, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Put, url, null, param);
    }

    public static String put(String url, Object header, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Put, url, header, param);
    }

    public static String delete(String url) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Delete, url, null, null);
    }

    public static String delete(String url, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Delete, url, null, param);
    }

    public static String delete(String url, Object header, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.Delete, url, header, param);
    }

    public static CloseableHttpResponse originalSend(Protocol protocol, RequestMethod method, String url, Object header, Object param) {
        try {
            CloseableHttpClient httpClient = HttpUtil.getHttpClient(protocol);
            HttpRequestBase httpRequestBase = HttpUtil.getHttpRequestBase(method);
            HttpUtil.parseHeader(header, httpRequestBase);
            url = HttpUtil.parseParam(url, param, httpRequestBase);
            url = HttpUtil.parseUrl(protocol, url);
            httpRequestBase.setURI(URI.create(url));
            return httpClient.execute((HttpUriRequest)httpRequestBase);
        }
        catch (NotFoundRequestMethodException e) {
            logger.error("\u7b2c\u4e8c\u4e2a\u53c2\u6570 method \u672a\u6210\u529f\u5206\u6790\u51fa\u8bf7\u6c42\u65b9\u5f0f", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String send(Protocol protocol, RequestMethod method, String url, Object header, Object param) {
        try (CloseableHttpResponse response = HttpUtil.originalSend(protocol, method, url, header, param);){
            String string = HttpUtil.toStringContent((HttpResponse)response);
            return string;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static String parseParam(String url, Object param, HttpRequestBase httpRequestBase) {
        if (param != null && httpRequestBase instanceof HttpEntityEnclosingRequestBase) {
            StringEntity entity = new StringEntity(JSON.toJSONString((Object)param), StandardCharsets.UTF_8);
            ((HttpEntityEnclosingRequestBase)httpRequestBase).setEntity((HttpEntity)entity);
        } else if (param != null) {
            Map<String, Object> paramMap = ObjectUtil.to(param, new TypeReference<Map<String, Object>>(){});
            String paramUrl = MapUtil.toUrl(paramMap);
            url = url.contains("?") ? url + paramUrl : url + "?" + paramUrl;
        }
        return url;
    }

    private static void parseHeader(Object header, HttpRequestBase httpRequestBase) {
        Map<String, Object> map = ObjectUtil.to(header, new TypeReference<Map<String, Object>>(){});
        if (map instanceof Header) {
            httpRequestBase.setHeader((Header)map);
        } else if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                httpRequestBase.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
            if (httpRequestBase.getHeaders(CONTENT_TYPE) == null) {
                httpRequestBase.setHeader(CONTENT_TYPE, "application/json; charset=utf-8");
            }
            if (httpRequestBase.getHeaders(CONNECTION) == null) {
                httpRequestBase.setHeader(CONNECTION, "Close");
            }
        }
    }

    private static HttpRequestBase getHttpRequestBase(RequestMethod method) throws NotFoundRequestMethodException {
        HttpGet httpRequestBase;
        switch (method) {
            case Get: {
                httpRequestBase = new HttpGet();
                break;
            }
            case Put: {
                httpRequestBase = new HttpPut();
                break;
            }
            case Post: {
                httpRequestBase = new HttpPost();
                break;
            }
            case Delete: {
                httpRequestBase = new HttpDelete();
                break;
            }
            default: {
                throw new NotFoundRequestMethodException();
            }
        }
        return httpRequestBase;
    }

    private static String parseUrl(Protocol protocol, String url) {
        url = url.trim();
        String lowerCase = url.toLowerCase();
        if (Protocol.Https == protocol && !lowerCase.startsWith(HTTPS)) {
            url = HTTPS + url;
        } else if (Protocol.Http == protocol && !lowerCase.startsWith(HTTP)) {
            url = HTTP + url;
        }
        return url;
    }

    private static CloseableHttpClient getHttpClient(Protocol protocol) throws KeyManagementException, NoSuchAlgorithmException {
        CloseableHttpClient httpClient = protocol == Protocol.Https ? HttpUtil.getHttpsClient() : HttpClients.createDefault();
        return httpClient;
    }

    public static CloseableHttpClient getHttpsClient() throws KeyManagementException, NoSuchAlgorithmException {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(HttpUtil.createIgnoreVerifySSL())).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    public static SSLContext createIgnoreVerifySSL() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        return sslContext;
    }

    private static String toStringContent(HttpResponse response) {
        if (response == null) {
            return null;
        }
        StringBuilder temp = new StringBuilder();
        try (InputStreamReader re = new InputStreamReader(response.getEntity().getContent());
             BufferedReader bufferedReader = new BufferedReader(re);){
            String line;
            String newLine = System.getProperty("line.separator");
            while ((line = bufferedReader.readLine()) != null) {
                temp.append(line).append(newLine);
            }
        }
        catch (IOException e) {
            logger.error("\u54cd\u5e94\u6d41\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
        }
        return temp.toString();
    }

    public static boolean isIPv4(String str) {
        if (!Pattern.matches("[0-9]*[.][0-9]*[.][0-9]*[.][0-9]*", str)) {
            return false;
        }
        String[] arrays = str.split("\\.");
        return Integer.parseInt(arrays[0]) < 256 && arrays[0].length() <= 3 && Integer.parseInt(arrays[1]) < 256 && arrays[0].length() <= 3 && Integer.parseInt(arrays[2]) < 256 && arrays[0].length() <= 3 && Integer.parseInt(arrays[3]) < 256 && arrays[0].length() <= 3;
    }

    public static boolean isIPv6(String str) {
        return Pattern.matches("[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]", str);
    }
}

