/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.command;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandUtil {
    private static Log log = LogFactory.getLog(CommandUtil.class);

    public static boolean extractProcess(Process p) throws IOException {
        InputStreamReader input = new InputStreamReader(p.getInputStream());
        InputStreamReader errors = new InputStreamReader(p.getErrorStream());
        for (String line : IOUtils.readLines((Reader)input)) {
            if (line.startsWith("[ERROR]")) {
                log.error((Object)line);
                continue;
            }
            if (line.startsWith("[WARNING]")) {
                log.warn((Object)line);
                continue;
            }
            log.info((Object)line);
        }
        for (String line : IOUtils.readLines((Reader)errors)) {
            if (line.startsWith("[ERROR]")) {
                log.error((Object)line);
                continue;
            }
            if (line.startsWith("[WARNING]")) {
                log.warn((Object)line);
                continue;
            }
            log.info((Object)line);
        }
        p.getOutputStream().close();
        try {
            if (p.waitFor() != 0) {
                log.warn((Object)"The command did not complete successfully");
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }
}

