/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.collection;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.collection.CollectionsUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class TreeUtil {
    public static <T> List<T> createTree(List<T> list, String key, String parentKey, String childrenKey, String rootValue) throws NoSuchFieldException, IllegalAccessException {
        return TreeUtil.createTree(list, key, parentKey, childrenKey, null, ".", rootValue, new String[0]);
    }

    public static <T> List<T> createTree(List<T> list, String key, String parentKey, String childrenKey, String sortKey, String rootValue, String splitChar, String ... fullFields) throws NoSuchFieldException, IllegalAccessException {
        ArrayList roots = new ArrayList();
        if (!list.isEmpty()) {
            T entity = list.get(0);
            Class<?> tClass = entity.getClass();
            Field keyField = tClass.getDeclaredField(key);
            keyField.setAccessible(true);
            Field parentKeyField = tClass.getDeclaredField(parentKey);
            parentKeyField.setAccessible(true);
            Field childrenKeyField = tClass.getDeclaredField(childrenKey);
            childrenKeyField.setAccessible(true);
            Set<Field> fullFieldSet = Stream.of(fullFields).map(fieldName -> {
                Field fullField;
                try {
                    fullField = ClassUtil.getField(tClass, fieldName);
                }
                catch (Exception e) {
                    return null;
                }
                fullField.setAccessible(true);
                return fullField;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            Object parent = ClassUtil.newInstance(tClass);
            keyField.set(parent, rootValue);
            return TreeUtil.createChildren(parent, list, keyField, parentKeyField, childrenKeyField, sortKey, splitChar, fullFieldSet);
        }
        return roots;
    }

    private static <T> List<T> createChildren(T parentNode, List<T> list, Field keyField, Field parentKeyField, Field childrenKeyField, String sortKey, String splitChar, Set<Field> fullFieldSet) throws IllegalAccessException {
        ArrayList<T> children = new ArrayList<T>();
        Object parentNodeKeyValue = keyField.get(parentNode);
        for (T currentNode : list) {
            Object currentNodeParentKeyValue = ObjectUtil.getFieldValue(currentNode, parentKeyField);
            boolean isChild = parentNodeKeyValue == null && currentNodeParentKeyValue == null || parentNodeKeyValue != null && parentNodeKeyValue.equals(currentNodeParentKeyValue);
            if (!isChild) continue;
            children.add(currentNode);
            for (Field field : fullFieldSet) {
                Object parentValue = ObjectUtil.getFieldValue(parentNode, field);
                if (parentValue == null) continue;
                field.set(currentNode, parentValue + splitChar + ObjectUtil.getFieldValue(currentNode, field));
            }
            childrenKeyField.set(currentNode, TreeUtil.createChildren(currentNode, list, keyField, parentKeyField, childrenKeyField, sortKey, splitChar, fullFieldSet));
        }
        if (StringUtils.isBlank((CharSequence)sortKey) || children.isEmpty()) {
            return children;
        }
        CollectionsUtil.sort(children, sortKey);
        return children;
    }
}

