/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.util;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.util.CacheUtil;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.dictionary.DictionaryData;
import cloud.agileframework.dictionary.annotation.Dictionary;
import cloud.agileframework.dictionary.annotation.DirectionType;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public final class DictionaryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryUtil.class);
    private static final String DEFAULT_CACHE_NAME = "dictionary-cache";
    private static final String CODE_FORMAT = "%s.%s";
    private static final String DEFAULT_NAME = "$DEFAULT_NAME";
    private static Map<String, String> dicCoverCache;

    private DictionaryUtil() {
    }

    public static AgileCache getCache() {
        return CacheUtil.getCache((String)DEFAULT_CACHE_NAME);
    }

    public static DictionaryData coverDicBean(String fullCode) {
        return DictionaryUtil.getDictionary(fullCode, "codeCache", "not found dictionary of fullCode {}", ".");
    }

    public static DictionaryData coverDicBean(String fullCode, String splitChar) {
        return DictionaryUtil.getDictionary(fullCode, "codeCache", "not found dictionary of fullCode {}", splitChar);
    }

    public static DictionaryData coverDicBeanByFullName(String fullName) {
        return DictionaryUtil.getDictionary(fullName, "nameCache", "not found dictionary of fullName {}", ".");
    }

    public static DictionaryData coverDicBeanByFullName(String fullName, String splitChar) {
        return DictionaryUtil.getDictionary(fullName, "nameCache", "not found dictionary of fullName {}", splitChar);
    }

    public static DictionaryData coverDicBeanByParent(String parentCode, String name) {
        if (StringUtils.isEmpty((CharSequence)parentCode) || StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        DictionaryData dic = DictionaryUtil.coverDicBean(parentCode);
        if (dic == null) {
            return null;
        }
        return DictionaryUtil.coverDicBeanByFullName(dic.getFullName() + "." + name);
    }

    private static DictionaryData getDictionary(String fullIndex, String cacheKey, String errorMessage, String splitChar) {
        if (StringUtils.isEmpty((CharSequence)fullIndex)) {
            return null;
        }
        fullIndex = fullIndex.replace(splitChar, "$SPLIT$");
        DictionaryData entity = (DictionaryData)DictionaryUtil.getCache().getFromMap((Object)cacheKey, (Object)fullIndex, DictionaryData.class);
        if (entity == null) {
            LOGGER.error(errorMessage, (Object)fullIndex.replace("$SPLIT$", "/"));
            return null;
        }
        return entity;
    }

    public static String coverDicName(String fullCodes) {
        return DictionaryUtil.coverDicName(fullCodes, DEFAULT_NAME, false, ".");
    }

    public static String coverDicName(String fullCodes, String defaultName) {
        return DictionaryUtil.coverDicName(fullCodes, defaultName, false, ".");
    }

    public static String coverDicNameByParent(String parentCode, String codes) {
        return DictionaryUtil.coverDicNameByParent(parentCode, codes, null, false, ".");
    }

    public static String coverDicNameByParent(String parentCode, String codes, String defaultValue) {
        return DictionaryUtil.coverDicNameByParent(parentCode, codes, defaultValue, false, ".");
    }

    public static String coverDicNameByParent(String parentCode, String codes, String defaultValue, boolean isFull, String splitChar) {
        if (StringUtils.isBlank((CharSequence)parentCode) || StringUtils.isBlank((CharSequence)codes)) {
            return defaultValue;
        }
        codes = parentCode + splitChar + codes;
        codes = codes.replace(",", "," + parentCode + ".");
        return DictionaryUtil.coverDicName(codes, defaultValue, isFull, splitChar);
    }

    public static String coverDicName(String fullCodes, String defaultName, boolean isFull, String splitChar) {
        if (fullCodes == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Arrays.stream(fullCodes.split(",")).forEach(c -> {
            DictionaryData targetEntity = DictionaryUtil.coverDicBean(c);
            if (builder.length() > 0) {
                builder.append(",");
            }
            if (targetEntity == null) {
                if (DEFAULT_NAME.equals(defaultName)) {
                    builder.append(StringUtil.getSplitByStrLastAtomic((String)c, (String)splitChar));
                } else if (defaultName != null) {
                    builder.append(defaultName);
                }
            } else if (isFull) {
                builder.append(targetEntity.getFullName().replace("$SPLIT$", splitChar));
            } else {
                builder.append(targetEntity.getName().replace("$SPLIT$", splitChar));
            }
        });
        return builder.toString();
    }

    public static String coverDicCode(String fullNames) {
        return DictionaryUtil.coverDicCode(fullNames, DEFAULT_NAME, false, ".");
    }

    public static String coverDicCode(String fullNames, String defaultCode) {
        return DictionaryUtil.coverDicCode(fullNames, defaultCode, false, ".");
    }

    public static String coverDicCodeByParent(String parentName, String names) {
        return DictionaryUtil.coverDicCodeByParent(parentName, names, null, false, ".");
    }

    public static String coverDicCodeByParent(String parentName, String names, String defaultCode) {
        return DictionaryUtil.coverDicCodeByParent(parentName, names, defaultCode, false, ".");
    }

    public static String coverDicCodeByParent(String parentName, String names, String defaultCode, boolean isFull, String splitChar) {
        if (StringUtils.isBlank((CharSequence)parentName) || StringUtils.isBlank((CharSequence)names)) {
            return defaultCode;
        }
        names = parentName + splitChar + names;
        names = names.replace(",", "," + parentName + splitChar);
        return DictionaryUtil.coverDicCode(names, defaultCode, isFull, splitChar);
    }

    public static String coverDicCode(String fulNames, String defaultCode, boolean isFull, String splitChar) {
        if (fulNames == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Arrays.stream(fulNames.split(",")).forEach(c -> {
            DictionaryData targetEntity = DictionaryUtil.coverDicBeanByFullName(c, splitChar);
            if (builder.length() > 0) {
                builder.append(",");
            }
            if (targetEntity == null) {
                if (DEFAULT_NAME.equals(defaultCode)) {
                    builder.append(StringUtil.getSplitByStrLastAtomic((String)c, (String)splitChar));
                } else if (defaultCode != null) {
                    builder.append(defaultCode);
                }
            } else if (isFull) {
                builder.append(targetEntity.getFullCode().replace("$SPLIT$", splitChar));
            } else {
                builder.append(targetEntity.getCode().replace("$SPLIT$", splitChar));
            }
        });
        return builder.toString();
    }

    public static <T> List<Map<String, Object>> coverMapDictionary(List<T> list, String dictionaryCode, String suffix, String column) throws NoSuchFieldException, IllegalAccessException {
        return DictionaryUtil.coverMapDictionary(list, new String[]{dictionaryCode}, suffix, new String[]{column});
    }

    public static <T> List<Map<String, Object>> coverMapDictionary(List<T> list, String[] dictionaryCodes, String suffix, String[] columns) throws NoSuchFieldException, IllegalAccessException {
        if (dictionaryCodes == null || columns == null || dictionaryCodes.length != columns.length) {
            throw new IllegalArgumentException("dictionaryCodes and columns should be the same length");
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(list.size());
        for (T o : list) {
            result.add(DictionaryUtil.coverMapDictionary(o, dictionaryCodes, suffix, columns));
        }
        return result;
    }

    public static <T> Map<String, Object> coverMapDictionary(T o, String[] dictionaryCodes, String suffix, String[] columns) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = o.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)o;
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                map.put(column + suffix, DictionaryUtil.coverDicName(String.format(CODE_FORMAT, dictionaryCodes[i], map.get(column))));
            }
            return map;
        }
        Map<String, Field> cache = DictionaryUtil.initField(clazz, columns);
        Map map = (Map)ObjectUtil.to(o, (TypeReference)new TypeReference<Map<String, Object>>(){});
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            Field field = cache.get(column);
            Object value = field.get(o);
            map.put(column + suffix, DictionaryUtil.coverDicName(String.format(CODE_FORMAT, dictionaryCodes[i], value)));
        }
        return map;
    }

    public static <T> List<T> coverBeanDictionary(List<T> list, String dictionaryCode, String column, String textColumn) throws IllegalAccessException, NoSuchFieldException {
        return DictionaryUtil.coverBeanDictionary(list, new String[]{dictionaryCode}, new String[]{column}, new String[]{textColumn}, null);
    }

    public static <T> T coverBeanDictionary(T o, String[] dictionaryCodes, String[] columns, String[] textColumns) throws IllegalAccessException, NoSuchFieldException {
        return DictionaryUtil.coverBeanDictionary(o, dictionaryCodes, columns, textColumns, null);
    }

    public static <T> T coverBeanDictionary(T o, String[] dictionaryCodes, String[] columns, String[] textColumns, String[] defaultValues) throws IllegalAccessException, NoSuchFieldException {
        Class<?> clazz = o.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)o;
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                String textColumn = textColumns[i];
                if (defaultValues == null || defaultValues.length <= i) {
                    map.put(textColumn, DictionaryUtil.coverDicNameByParent(dictionaryCodes[i], String.valueOf(map.get(column))));
                    continue;
                }
                String defaultValue = defaultValues[i];
                map.put(textColumn, DictionaryUtil.coverDicNameByParent(dictionaryCodes[i], String.valueOf(map.get(column)), defaultValue));
            }
            return (T)map;
        }
        Map<String, Field> cache = DictionaryUtil.initField(clazz, columns);
        cache.putAll(DictionaryUtil.initField(clazz, textColumns));
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String textColumn = textColumns[i];
            Field field = cache.get(column);
            Field textField = cache.get(textColumn);
            Object value = field.get(o);
            if (defaultValues == null || defaultValues.length <= i) {
                textField.set(o, DictionaryUtil.coverDicNameByParent(dictionaryCodes[i], String.valueOf(value)));
                continue;
            }
            String defaultValue = defaultValues[i];
            textField.set(o, DictionaryUtil.coverDicNameByParent(dictionaryCodes[i], String.valueOf(value), defaultValue));
        }
        return o;
    }

    public static <T> List<T> coverBeanDictionary(List<T> list, String[] dictionaryCodes, String[] columns, String[] textColumns, String[] defaultValues) throws IllegalAccessException, NoSuchFieldException {
        ArrayList<T> result = new ArrayList<T>(list.size());
        for (T o : list) {
            result.add(DictionaryUtil.coverBeanDictionary(o, dictionaryCodes, columns, textColumns, defaultValues));
        }
        return result;
    }

    private static Map<String, Field> initField(Class<?> clazz, String ... columns) throws NoSuchFieldException {
        HashMap<String, Field> cache = new HashMap<String, Field>(columns.length);
        for (String column : columns) {
            if (cache.containsKey(column)) continue;
            Field field = clazz.getDeclaredField(column);
            field.setAccessible(true);
            cache.put(column, field);
        }
        return cache;
    }

    public static <T> void cover(T o) {
        if (ObjectUtils.isEmpty(o)) {
            return;
        }
        if (Collection.class.isAssignableFrom(o.getClass())) {
            DictionaryUtil.cover((Collection)o);
        }
        Set targets = ClassUtil.getAllEntityAnnotation(o.getClass(), Dictionary.class);
        targets.forEach(target -> {
            Field field;
            Dictionary dictionary = (Dictionary)target.getAnnotation();
            Member member = target.getMember();
            if (member instanceof Method) {
                String fieldName = StringUtil.toLowerName((String)member.getName().substring(3));
                field = ClassUtil.getField(o.getClass(), (String)fieldName);
                if (ObjectUtils.isEmpty((Object)field)) {
                    return;
                }
            } else if (member instanceof Field) {
                field = (Field)member;
            } else {
                return;
            }
            DictionaryUtil.parseNodeField(dictionary, field, o);
        });
    }

    public static <T> void cover(Collection<T> collection) {
        if (ObjectUtils.isEmpty(collection)) {
            return;
        }
        if (dicCoverCache == null) {
            dicCoverCache = Maps.newConcurrentMap();
        }
        Collections.synchronizedCollection(collection).parallelStream().forEach(DictionaryUtil::cover);
        dicCoverCache.clear();
    }

    private static <T> void parseNodeField(Dictionary dictionary, Field field, T node) {
        String targetName;
        String parentDicCode = dictionary.dicCode();
        boolean isFull = dictionary.isFull();
        String split = dictionary.split();
        String codeStr = Arrays.stream(dictionary.fieldName()).map(column -> {
            Object code = ObjectUtil.getFieldValue((Object)node, (String)column);
            if (ObjectUtils.isEmpty((Object)code)) {
                return null;
            }
            if (code instanceof Boolean) {
                return Boolean.TRUE.equals(code) ? "1" : "0";
            }
            if (code.getClass().isEnum()) {
                return ((Enum)code).name();
            }
            return code.toString();
        }).filter(Objects::nonNull).collect(Collectors.joining(split));
        String fullCode = ObjectUtils.isEmpty((Object)parentDicCode) ? codeStr : parentDicCode + "." + codeStr;
        if (dicCoverCache != null && dicCoverCache.containsKey(fullCode)) {
            targetName = dicCoverCache.get(fullCode);
        } else {
            targetName = isFull ? (dictionary.directionType() == DirectionType.CodeToName ? DictionaryUtil.coverDicName(fullCode, DEFAULT_NAME, true, split) : DictionaryUtil.coverDicCode(fullCode, DEFAULT_NAME, true, split)) : (dictionary.directionType() == DirectionType.CodeToName ? DictionaryUtil.coverDicName(fullCode) : DictionaryUtil.coverDicCode(fullCode));
            if (dicCoverCache != null) {
                dicCoverCache.put(fullCode, targetName);
            }
        }
        ObjectUtil.setValue(node, (Field)field, (Object)targetName);
    }
}

