/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.config;

import cloud.agileframework.dictionary.DictionaryDataManager;
import cloud.agileframework.dictionary.DictionaryDataManagerProxy;
import cloud.agileframework.dictionary.DictionaryEngine;
import cloud.agileframework.dictionary.MemoryDictionaryManager;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(name={"cloud.agileframework.jpa.config.DaoAutoConfiguration.class"})
@ConditionalOnProperty(name={"enable"}, prefix="agile.dictionary")
public class DictionaryAutoConfiguration {
    @Bean
    DictionaryEngine dictionaryEngine() {
        return new DictionaryEngine();
    }

    @Bean
    @ConditionalOnMissingBean(value={DictionaryDataManager.class})
    MemoryDictionaryManager dictionaryManager() {
        return new MemoryDictionaryManager();
    }

    @Bean
    @ConditionalOnBean(value={DictionaryDataManager.class})
    DictionaryDataManagerProxy dictionaryDataManagerProxy(DictionaryDataManager dictionaryDataManager) {
        return new DictionaryDataManagerProxy(dictionaryDataManager);
    }
}

