/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary;

import cloud.agileframework.dictionary.DictionaryData;
import cloud.agileframework.dictionary.DictionaryDataManager;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MemoryDictionaryManager
implements DictionaryDataManager {
    private static final Set<DictionaryData> CACHE = Sets.newHashSet();

    @Override
    public List<DictionaryData> all() {
        return new ArrayList<DictionaryData>(CACHE);
    }

    @Override
    public void add(DictionaryData dictionaryData) {
        CACHE.add(dictionaryData);
    }

    @Override
    public void delete(DictionaryData dictionaryData) {
        CACHE.removeIf(n -> dictionaryData.getId().equals(n.getId()));
    }

    @Override
    public void update(DictionaryData dictionaryData) {
        this.delete(dictionaryData);
        this.add(dictionaryData);
    }
}

