/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary;

import cloud.agileframework.common.util.collection.TreeUtil;
import cloud.agileframework.dictionary.DictionaryData;
import cloud.agileframework.dictionary.DictionaryDataManager;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class DictionaryEngine
implements ApplicationRunner {
    public static final String CODE_CACHE = "codeCache";
    public static final String NAME_CACHE = "nameCache";
    public static final String DEFAULT_SPLIT_CHAR = "$SPLIT$";
    @Autowired
    private DictionaryDataManager dictionaryDataManager;

    public void run(ApplicationArguments args) throws Exception {
        List<DictionaryData> list = this.dictionaryDataManager.all();
        TreeUtil.createTree(list, (String)"id", (String)"parentId", (String)"children", (String)"code", null, (String)DEFAULT_SPLIT_CHAR, (String[])new String[]{"fullName", "fullCode"});
        this.refreshCache(list);
    }

    public void refreshCache(List<DictionaryData> list) {
        HashMap codeCache = Maps.newHashMapWithExpectedSize((int)list.size());
        HashMap nameCache = Maps.newHashMapWithExpectedSize((int)list.size());
        list.forEach(dic -> {
            codeCache.put(dic.getFullCode(), dic);
            nameCache.put(dic.getFullName(), dic);
        });
        DictionaryUtil.getCache().put((Object)CODE_CACHE, (Object)codeCache);
        DictionaryUtil.getCache().put((Object)NAME_CACHE, (Object)nameCache);
    }
}

