/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary;

import cloud.agileframework.dictionary.DictionaryData;
import cloud.agileframework.dictionary.DictionaryDataManager;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DictionaryDataManagerProxy {
    private DictionaryDataManager dictionaryDataManager;

    public DictionaryDataManagerProxy(DictionaryDataManager dictionaryDataManager) {
        this.dictionaryDataManager = dictionaryDataManager;
    }

    public List<DictionaryData> all() {
        return this.dictionaryDataManager.all();
    }

    public void add(DictionaryData dictionaryData) {
        this.dictionaryDataManager.add(dictionaryData);
        this.add("codeCache", dictionaryData, DictionaryData::getFullCode);
        this.add("nameCache", dictionaryData, DictionaryData::getFullName);
    }

    private void add(String cacheKey, DictionaryData dictionaryData, Function<DictionaryData, String> function) {
        Map map = (Map)DictionaryUtil.getCache().get((Object)cacheKey, Map.class);
        assert (map != null);
        map.values().stream().filter(n -> n.getId().equals(dictionaryData.getParentId())).forEach(n -> {
            dictionaryData.setFullCode(n.getFullCode() + "$SPLIT$" + dictionaryData.getCode());
            dictionaryData.setFullName(n.getFullName() + "$SPLIT$" + dictionaryData.getName());
            List<DictionaryData> children = dictionaryData.getChildren();
            if (children != null) {
                children.forEach(this::add);
                n.getChildren().add(dictionaryData);
            }
        });
        map.put(function.apply(dictionaryData), dictionaryData);
        DictionaryUtil.getCache().put((Object)cacheKey, (Object)map);
    }

    public void delete(String fullCode) {
        DictionaryData dictionaryData = DictionaryUtil.coverDicBean(fullCode);
        this.dictionaryDataManager.delete(dictionaryData);
        this.delete(dictionaryData);
    }

    public void delete(DictionaryData dictionaryData) {
        this.delete("codeCache", dictionaryData, dictionaryData.getFullCode());
        this.delete("nameCache", dictionaryData, dictionaryData.getFullName());
    }

    private void delete(String cacheKey, DictionaryData dictionaryData, String removeKey) {
        Map map = (Map)DictionaryUtil.getCache().get((Object)cacheKey, Map.class);
        assert (map != null);
        map.values().removeIf(n -> dictionaryData.getId().equals(n.getId()));
        map.remove(removeKey);
    }

    public void update(DictionaryData dictionaryData) {
        this.dictionaryDataManager.update(dictionaryData);
        this.delete(dictionaryData);
        this.add(dictionaryData);
    }
}

