/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ASTUtil;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.AnonymousInnerClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ArrayDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.BaseScope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.BlockDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassImportException;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassManager;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.DefaultConstructor;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Definition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.DotIterator;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalPackage;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IPackage;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.LabelDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.MethodDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.PackageDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Resolver;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Scope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymbolTable;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymbolTableException;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.VariableDef;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class TableMaker {
    private SymbolTable symbolTable;
    private SymTabAST _tree;
    private File currentFile;
    private Vector imports = new Vector();
    static /* synthetic */ Class class$java$lang$Object;

    public TableMaker(SymTabAST tree) {
        this._tree = tree;
    }

    public SymTabAST getTree() {
        return this._tree;
    }

    public SymbolTable getTable() throws SymbolTableException {
        if (this.symbolTable == null) {
            this.symbolTable = new SymbolTable(this._tree);
            this.createDefinitions();
            this.resolveReferences();
        }
        return this.symbolTable;
    }

    private void createDefinitions() throws SymbolTableException {
        this.walkTree();
        this.finishCreatingDefinitions();
    }

    private void finishCreatingDefinitions() throws SymbolTableException {
        this.finishCreatingDefinition(this.symbolTable.getBaseScope());
    }

    private void finishCreatingDefinition(Definition def) throws SymbolTableException {
        if (def instanceof AnonymousInnerClass) {
            AnonymousInnerClass innerClass = (AnonymousInnerClass)def;
            innerClass.finishMakingDefinition();
        } else if (def instanceof ClassDef) {
            new ClassFinisher(def).finish();
        } else if (def instanceof VariableDef) {
            new VariableFinisher(def).finish();
        } else if (!(def instanceof DefaultConstructor)) {
            if (def instanceof MethodDef) {
                new MethodFinisher(def).finish();
            } else if (def instanceof BlockDef) {
                SymTabAST firstChild = (SymTabAST)def.getTreeNode().getFirstChild();
                if (firstChild.getType() == 76) {
                    firstChild = (SymTabAST)firstChild.getNextSibling();
                }
                if (firstChild.getType() == 21) {
                    new CatchFinisher((BlockDef)def).finish();
                }
            }
        }
        if (def instanceof Scope) {
            this.finishCreatingChildren((Scope)def);
        }
    }

    private void finishCreatingChildren(Scope scope) throws SymbolTableException {
        Enumeration definitions = scope.getDefinitions();
        while (definitions.hasMoreElements()) {
            Definition child = (Definition)definitions.nextElement();
            this.finishCreatingDefinition(child);
        }
    }

    private void resolveReferences() {
        new Resolver(this.symbolTable).resolve();
    }

    public void walkTree() {
        this.walkSiblings((SymTabAST)this._tree.getFirstChild(), false);
    }

    public void walkTree(SymTabAST tree, boolean makeAnonymousScopes) {
        if (tree != null) {
            tree.setScope(this.symbolTable.getCurrentScope());
            switch (tree.getType()) {
                case 0: {
                    this.processFile(tree);
                    if (tree.getFirstChild().getType() != 16) {
                        this.processImplicitPackage(tree.getFile());
                    }
                    this.walkSiblings((SymTabAST)tree.getFirstChild(), false);
                    this.symbolTable.popScope();
                    this.clearImports();
                    break;
                }
                case 136: {
                    SymTabAST symtabTree = tree;
                    this.walkTree(symtabTree.findFirstToken(34), makeAnonymousScopes);
                    SymTabAST objblock = symtabTree.findFirstToken(6);
                    if (objblock == null) break;
                    SymTabAST classExtended = symtabTree.findFirstToken(58);
                    this.processAnonymousInnerClass(objblock, classExtended);
                    break;
                }
                case 7: {
                    if (makeAnonymousScopes) {
                        this.processBlock(tree, true);
                        break;
                    }
                    this.walkSiblings((SymTabAST)tree.getFirstChild(), true);
                    break;
                }
                case 8: {
                    this.processConstructorDef(tree);
                    break;
                }
                case 9: {
                    this.processMethodDef(tree);
                    break;
                }
                case 97: {
                    this.processFinally(tree);
                    break;
                }
                case 95: {
                    this.processTry(tree);
                    break;
                }
                case 10: {
                    this.processVariableDef(tree);
                    break;
                }
                case 16: {
                    this.processPackage(tree);
                    break;
                }
                case 22: {
                    this.processLabel(tree);
                    break;
                }
                case 30: {
                    this.processImport(tree);
                    break;
                }
                case 14: 
                case 15: {
                    this.processClass(tree);
                    break;
                }
                case 91: {
                    this.processFor(tree);
                    break;
                }
                case 83: {
                    this.processIf(tree);
                    break;
                }
                case 151: {
                    this.processAssert(tree);
                    break;
                }
                case 11: 
                case 12: 
                case 67: 
                case 84: 
                case 85: 
                case 89: 
                case 96: {
                    this.processBlock(tree, false);
                    break;
                }
                default: {
                    this.walkSiblings((SymTabAST)tree.getFirstChild(), false);
                }
            }
        }
    }

    public void processAssert(SymTabAST tree) {
        SymTabAST message;
        BlockDef block = this.makeBlock(tree);
        SymTabAST expr = tree.findFirstToken(28);
        for (message = (SymTabAST)expr.getNextSibling(); message != null && message.getType() != 28; message = (SymTabAST)message.getNextSibling()) {
        }
        this.symbolTable.pushScope(block);
        this.walkTree(expr, false);
        if (message != null) {
            this.walkTree(message, false);
        }
        this.symbolTable.popScope();
    }

    public void walkSiblings(SymTabAST tree, boolean makeAnonymousScopes) {
        while (tree != null) {
            this.walkTree(tree, makeAnonymousScopes);
            tree = (SymTabAST)tree.getNextSibling();
        }
    }

    public void processPackage(SymTabAST tree) {
        SymTabAST firstChild = (SymTabAST)tree.getFirstChild();
        String name = ASTUtil.constructDottedName(firstChild);
        firstChild.ignoreChildren();
        PackageDef pkg = this.symbolTable.getPackage(name);
        if (pkg == null) {
            pkg = this.createPackage((SymTabAST)tree.getFirstChild());
        }
        this.symbolTable.pushScope(pkg);
    }

    public void processImplicitPackage(File file) {
        PackageDef pkg;
        String name = file.getParent();
        if (name == null) {
            name = "";
        }
        if ((pkg = this.symbolTable.getPackage(name)) == null) {
            pkg = new PackageDef(name, this.symbolTable.getBaseScope(), null);
            this.symbolTable.definePackage(pkg, this.symbolTable.getBaseScope());
        }
        this.symbolTable.pushScope(pkg);
    }

    private PackageDef createPackage(SymTabAST tree) {
        PackageDef result = null;
        if (tree.getType() == 59) {
            SymTabAST leftChild = (SymTabAST)tree.getFirstChild();
            SymTabAST rightChild = (SymTabAST)leftChild.getNextSibling();
            PackageDef context = this.createPackage(leftChild);
            result = this.getPackage(context, rightChild);
        } else {
            result = this.getPackage(this.symbolTable.getBaseScope(), tree);
        }
        return result;
    }

    private PackageDef getPackage(Scope parent, SymTabAST tree) {
        String name = tree.getText();
        PackageDef result = null;
        result = !(parent instanceof BaseScope) ? this.symbolTable.getPackage(parent.getQualifiedName() + "." + name) : this.symbolTable.getPackage(name);
        if (result == null) {
            result = new PackageDef(tree.getText(), parent, tree);
            this.symbolTable.definePackage(result, parent);
        }
        return result;
    }

    public void processFile(SymTabAST tree) {
        this.setCurrentFile(tree.getText());
    }

    public void processImport(SymTabAST tree) {
        this.imports.add(tree);
    }

    private void clearImports() {
        this.imports.clear();
    }

    public void processLabel(SymTabAST tree) {
        String name = tree.findFirstToken(58).getText();
        LabelDef label = new LabelDef(name, this.symbolTable.getCurrentScope(), tree);
        this.symbolTable.defineLabel(label);
        this.walkTree((SymTabAST)tree.getFirstChild().getNextSibling(), false);
    }

    public void processClass(SymTabAST tree) {
        String name = tree.findFirstToken(58).getText();
        this.makeClass(name, tree);
        SymTabAST objblock = tree.findFirstToken(6);
        SymTabAST start = (SymTabAST)objblock.getFirstChild();
        if (start != null) {
            if (start.getType() == 76) {
                start = (SymTabAST)start.getNextSibling();
            }
            this.walkSiblings(start, false);
        }
        this.symbolTable.popScope();
    }

    public void makeClass(String name, SymTabAST tree) {
        ClassDef def = new ClassDef(name, this.symbolTable.getCurrentScope(), tree);
        def.addUnprocessedImports(this.imports);
        this.symbolTable.defineClass(def);
        this.symbolTable.pushScope(def);
    }

    public void processAnonymousInnerClass(SymTabAST objblock, SymTabAST classExtended) {
        AnonymousInnerClass def = new AnonymousInnerClass(objblock, classExtended, this.symbolTable.getCurrentScope());
        this.symbolTable.defineClass(def);
        this.symbolTable.pushScope(def);
        this.walkSiblings((SymTabAST)objblock.getFirstChild(), false);
        this.symbolTable.popScope();
    }

    private void processVariableDef(SymTabAST tree) {
        VariableDef def = this.makeVariableDef(tree, this.symbolTable.getCurrentScope());
        this.symbolTable.defineVariable(def);
        SymTabAST assignmentNode = tree.findFirstToken(80);
        if (assignmentNode != null) {
            this.walkTree((SymTabAST)assignmentNode.getFirstChild(), false);
        }
    }

    public VariableDef makeVariableDef(SymTabAST tree, Scope scope) {
        String name = tree.findFirstToken(58).getText();
        VariableDef result = new VariableDef(name, scope, tree);
        return result;
    }

    public void processTry(SymTabAST tree) {
        BlockDef block = this.makeBlock(tree);
        SymTabAST slist = tree.findFirstToken(7);
        SymTabAST everythingElse = (SymTabAST)slist.getNextSibling();
        this.symbolTable.pushScope(block);
        this.walkTree(slist, false);
        this.symbolTable.popScope();
        this.walkSiblings(everythingElse, false);
    }

    public void processFinally(SymTabAST tree) {
        BlockDef block = this.makeBlock(tree);
        SymTabAST slist = tree.findFirstToken(7);
        SymTabAST tryBlock = tree.findFirstToken(95);
        this.symbolTable.pushScope(block);
        this.walkTree(slist, false);
        this.symbolTable.popScope();
        this.walkTree(tryBlock, false);
    }

    public void processMethodDef(SymTabAST tree) {
        String name = tree.findFirstToken(58).getText();
        MethodDef method = new MethodDef(name, this.symbolTable.getCurrentScope(), tree);
        this.symbolTable.defineMethod(method);
        this.symbolTable.pushScope(method);
        this.walkTree(tree.findFirstToken(7), false);
        this.symbolTable.popScope();
    }

    public void processConstructorDef(SymTabAST tree) {
        this.processMethodDef(tree);
    }

    public void processFor(SymTabAST tree) {
        SymTabAST body;
        BlockDef block = this.makeBlock(tree);
        this.symbolTable.pushScope(block);
        SymTabAST forEach = tree.findFirstToken(156);
        if (forEach != null) {
            this.walkTree(forEach, false);
            body = (SymTabAST)forEach.getNextSibling();
        } else {
            this.walkTree(tree.findFirstToken(35), false);
            this.walkTree(tree.findFirstToken(36), false);
            SymTabAST forIter = tree.findFirstToken(37);
            this.walkTree(forIter, false);
            body = (SymTabAST)forIter.getNextSibling();
        }
        if (body.getType() == 77) {
            body = (SymTabAST)body.getNextSibling();
        }
        this.walkTree(body, false);
        this.symbolTable.popScope();
    }

    public void processIf(SymTabAST tree) {
        SymTabAST elseBranch;
        BlockDef block = this.makeBlock(tree);
        SymTabAST expr = tree.findFirstToken(28);
        SymTabAST ifBranch = (SymTabAST)expr.getNextSibling();
        if (ifBranch.getType() == 77) {
            ifBranch = (SymTabAST)ifBranch.getNextSibling();
        }
        if ((elseBranch = (SymTabAST)ifBranch.getNextSibling()) != null && elseBranch.getType() == 45) {
            elseBranch = (SymTabAST)elseBranch.getNextSibling();
        }
        if (elseBranch != null && elseBranch.getType() == 92) {
            elseBranch = (SymTabAST)elseBranch.getFirstChild();
        }
        this.symbolTable.pushScope(block);
        this.walkTree(expr, false);
        this.walkTree(ifBranch, false);
        this.symbolTable.popScope();
        this.processElse(elseBranch);
    }

    public void processElse(SymTabAST tree) {
        if (tree != null) {
            if (tree.getType() == 83) {
                this.processIf(tree);
            } else {
                this.makeElseBlock(tree);
            }
        }
    }

    public void makeElseBlock(SymTabAST tree) {
        if (tree.getType() == 7) {
            BlockDef block = this.makeBlock(tree);
            this.symbolTable.pushScope(block);
            this.walkTree(tree, false);
            this.symbolTable.popScope();
        } else {
            this.walkTree(tree, false);
        }
    }

    public void processBlock(SymTabAST tree, boolean makeAnonymousScopes) {
        BlockDef block = this.makeBlock(tree);
        this.symbolTable.pushScope(block);
        SymTabAST child = (SymTabAST)tree.getFirstChild();
        if (child != null && child.getType() == 76) {
            child = (SymTabAST)child.getNextSibling();
        }
        this.walkSiblings(child, makeAnonymousScopes);
        this.symbolTable.popScope();
    }

    public void setCurrentFile(String fileName) {
        this.currentFile = new File(fileName);
        this.symbolTable.setCurrentFile(this.currentFile);
    }

    private BlockDef makeBlock(SymTabAST tree) {
        BlockDef block = new BlockDef(this.symbolTable.getCurrentScope(), tree);
        this.symbolTable.defineBlock(block);
        return block;
    }

    public static SymTabAST getExtendsNode(ClassDef classDef) {
        SymTabAST result = null;
        SymTabAST extendsClause = null;
        SymTabAST classDefTreeNode = classDef.getTreeNode();
        extendsClause = classDefTreeNode.findFirstToken(18);
        if (extendsClause != null) {
            result = (SymTabAST)extendsClause.getFirstChild();
        }
        return result;
    }

    class CatchFinisher
    extends DefinitionFinisher {
        BlockDef _def;

        public CatchFinisher(BlockDef def) {
            super(def);
            this._def = null;
            this._def = def;
        }

        public void finish() {
            this.createExceptionVariable();
        }

        private void createExceptionVariable() {
            SymTabAST exceptionNode = this._def.getTreeNode().findFirstToken(21);
            VariableDef exception = TableMaker.this.makeVariableDef(exceptionNode, this._def);
            new VariableFinisher(exception).finish();
            this._def.addDefinition(exception);
        }
    }

    class MethodFinisher
    extends DefinitionFinisher {
        MethodDef _def;

        public MethodFinisher(Definition def) {
            super(def);
            this._def = null;
            this._def = (MethodDef)def;
        }

        public void finish() {
            this.setReturnType();
            this.setSignature();
            this.setExceptionsThrown();
        }

        private void setReturnType() {
            IClass type = null;
            type = this.isConstructor() ? this._def.getEnclosingClass() : this.getType(this._def, this.getTypeNode());
            this._def.setType(type);
        }

        private void setSignature() {
            SymTabAST parametersNode = this._node.findFirstToken(20);
            for (SymTabAST parameterNode = (SymTabAST)parametersNode.getFirstChild(); parameterNode != null; parameterNode = (SymTabAST)parameterNode.getNextSibling()) {
                if (parameterNode.getType() != 21) continue;
                VariableDef parameter = TableMaker.this.makeVariableDef(parameterNode, this._def);
                new VariableFinisher(parameter).finish();
                this._def.addParameter(parameter);
            }
        }

        private void setExceptionsThrown() {
            IClass exception = null;
            SymTabAST throwsNode = this._node.findFirstToken(81);
            if (throwsNode != null) {
                for (SymTabAST exceptionNode = (SymTabAST)throwsNode.getFirstChild(); exceptionNode != null; exceptionNode = (SymTabAST)exceptionNode.getNextSibling()) {
                    if (exceptionNode.getType() == 59) {
                        PackageDef pkg = TableMaker.this.symbolTable.getPackage(ASTUtil.constructPackage(exceptionNode));
                        if (pkg != null) {
                            exception = pkg.getClassDefinition(ASTUtil.constructClass(exceptionNode));
                        }
                    } else {
                        exception = this._def.getClassDefinition(exceptionNode.getText());
                    }
                    this._def.addException(exception);
                }
            }
        }

        private boolean isConstructor() {
            boolean result = false;
            if (this.getTypeNode() == null) {
                result = true;
            }
            return result;
        }

        private SymTabAST getTypeNode() {
            return this._node.findFirstToken(13);
        }
    }

    class VariableFinisher
    extends DefinitionFinisher {
        VariableDef _def;

        public VariableFinisher(Definition def) {
            super(def);
            this._def = null;
            this._def = (VariableDef)def;
        }

        public void finish() {
            SymTabAST typeNode = this._node.findFirstToken(13);
            SymTabAST typeTextNode = (SymTabAST)typeNode.getFirstChild();
            if (typeTextNode.getType() == 17) {
                typeTextNode = (SymTabAST)typeTextNode.getFirstChild();
            }
            typeTextNode.setLine(ASTUtil.getLine(this._def.getTreeNode()));
            IClass varType = this.getType(this._def, typeNode);
            this._def.setType(varType);
        }
    }

    class ClassFinisher
    extends DefinitionFinisher {
        private ClassDef _def;

        public ClassFinisher(Definition def) {
            super(def);
            this._def = null;
            this._def = (ClassDef)def;
        }

        public void finish() throws SymbolTableException {
            if (this._node != null) {
                this.addImports();
                this.setSuperclass();
                this.addInterfaces();
            }
        }

        private void addImports() throws ClassImportException {
            ExternalPackage java = new ExternalPackage("java", null);
            ExternalPackage lang = new ExternalPackage("lang", java);
            java.addDefinition(lang);
            this._def.importPackage(lang);
            Vector unprocessedImports = this._def.getUnprocessedImports();
            for (int i = 0; i < unprocessedImports.size(); ++i) {
                SymTabAST importNode = (SymTabAST)((Object)unprocessedImports.get(i));
                SymTabAST imported = (SymTabAST)importNode.getFirstChild();
                SymTabAST lastPart = (SymTabAST)imported.getFirstChild().getNextSibling();
                DotIterator it = new DotIterator(imported);
                SymTabAST current = null;
                String className = null;
                IClass importedClass = null;
                while (it.hasNext()) {
                    current = it.nextNode();
                    if (className == null) {
                        className = current.getText();
                    } else {
                        if (current.getText().equals("*")) break;
                        className = className + "." + current.getText();
                    }
                    if ((importedClass = this.findOrLoadClass(className, importedClass)) == null) continue;
                }
                if (it.hasNext()) {
                    boolean isImported = false;
                    while (it.hasNext()) {
                        current = it.nextNode();
                        if (current.getText().equals("*")) {
                            this.importInnerClasses(importedClass);
                            isImported = true;
                            continue;
                        }
                        className = className + "$" + current.getText();
                        importedClass = this.findOrLoadClass(className, importedClass);
                    }
                    if (!isImported) {
                        this._def.importClass(importedClass);
                    }
                } else if (importedClass != null) {
                    this._def.importClass(importedClass);
                } else if (current != null && current.getText().equals("*")) {
                    IPackage pkg = TableMaker.this.symbolTable.getPackage(className);
                    if (pkg == null) {
                        pkg = this.getPackage(className);
                    }
                    this._def.importPackage(pkg);
                }
                imported.ignoreChildren();
                if (lastPart.getType() != 58 || importedClass == null) continue;
                lastPart.setDefinition(importedClass, null, true);
                lastPart.setMeaningfulness(true);
            }
        }

        private ExternalPackage getPackage(String packageName) {
            return new ExternalPackage(packageName, null);
        }

        private void importInnerClasses(IClass outerClass) {
            IClass[] innerClasses = outerClass.getInnerClasses();
            for (int i = 0; i < innerClasses.length; ++i) {
                this._def.importClass(innerClasses[i]);
            }
        }

        private IClass loadClass(String className) {
            ExternalClass result = null;
            try {
                Class<?> javaClass = ClassManager.getClassLoader().loadClass(className);
                result = new ExternalClass(javaClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return result;
        }

        private IClass findOrLoadClass(String className, IClass parentClass) {
            IClass result = null;
            if (parentClass == null) {
                result = TableMaker.this.symbolTable.getBaseScope().getClassDefinition(className);
            } else {
                int index = className.lastIndexOf("$");
                if (index < 0) {
                    index = className.lastIndexOf(".");
                }
                result = parentClass.getClassDefinition(className.substring(index + 1));
            }
            if (result == null) {
                result = this.loadClass(className);
            }
            return result;
        }

        private void setSuperclass() {
            if (this._def.getTreeNode().getType() == 14) {
                SymTabAST extendsNode = TableMaker.getExtendsNode(this._def);
                if (extendsNode != null) {
                    String superclassName = ASTUtil.constructDottedName(extendsNode);
                    IClass superclass = this._def.getClassDefinition(superclassName);
                    if (superclass != null) {
                        this._def.setSuperclass(superclass);
                        superclass.addSubclass(this._def);
                    }
                } else {
                    this._def.setSuperclass(new ExternalClass(class$java$lang$Object == null ? (class$java$lang$Object = TableMaker.class$("java.lang.Object")) : class$java$lang$Object));
                }
            } else {
                this._def.setSuperclass(new ExternalClass(class$java$lang$Object == null ? (class$java$lang$Object = TableMaker.class$("java.lang.Object")) : class$java$lang$Object));
            }
        }

        private void addInterfaces() {
            SymTabAST implementsClause = null;
            implementsClause = this._def.getTreeNode().getType() == 14 ? this._node.findFirstToken(19) : this._node.findFirstToken(18);
            if (implementsClause != null) {
                for (SymTabAST interfaceNode = (SymTabAST)implementsClause.getFirstChild(); interfaceNode != null; interfaceNode = (SymTabAST)interfaceNode.getNextSibling()) {
                    IClass implemented = this._def.getClassDefinition(interfaceNode.getText());
                    if (implemented == null) continue;
                    this._def.addInterface(implemented);
                    implemented.addImplementor(this._def);
                }
            }
        }
    }

    class DefinitionFinisher {
        protected SymTabAST _node = null;

        public DefinitionFinisher(Definition def) {
            this._node = def.getTreeNode();
        }

        public void finish() throws SymbolTableException {
        }

        protected IClass getType(Definition def, SymTabAST typeNode) {
            IClass result = null;
            SymTabAST typeClassNode = null;
            boolean isArray = false;
            if (typeNode.getFirstChild().getType() == 17) {
                isArray = true;
                typeClassNode = (SymTabAST)typeNode.getFirstChild().getFirstChild();
            } else {
                typeClassNode = (SymTabAST)typeNode.getFirstChild();
            }
            Scope lookupScope = null;
            lookupScope = def instanceof Scope ? (Scope)def : def.getParentScope();
            Resolver resolver = new Resolver(TableMaker.this.symbolTable);
            IClass typeClass = resolver.resolveClass(typeClassNode, lookupScope, null, false);
            result = isArray ? new ArrayDef(typeClass) : typeClass;
            return result;
        }
    }
}

