/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.AnonymousInnerClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.BlockDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.DefaultConstructor;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Definition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.LabelDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.MethodDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.PackageDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Scope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymbolTable;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.VariableDef;
import java.util.Enumeration;
import java.util.Iterator;

public class DefinitionTraverser {
    protected SymbolTable _symbolTable;

    public DefinitionTraverser(SymbolTable symbolTable) {
        this._symbolTable = symbolTable;
    }

    public void traverse() {
        Enumeration packages = this._symbolTable.getPackages().elements();
        while (packages.hasMoreElements()) {
            this.traverse((PackageDef)packages.nextElement());
        }
    }

    private void traverse(Definition def) {
        if (def instanceof PackageDef) {
            this.traverse((PackageDef)def);
        } else if (def instanceof AnonymousInnerClass) {
            this.traverse((AnonymousInnerClass)def);
        } else if (def instanceof ClassDef) {
            this.traverse((ClassDef)def);
        } else if (def instanceof DefaultConstructor) {
            this.traverse((DefaultConstructor)def);
        } else if (def instanceof MethodDef) {
            this.traverse((MethodDef)def);
        } else if (def instanceof BlockDef) {
            this.traverse((BlockDef)def);
        } else if (def instanceof VariableDef) {
            this.traverse((VariableDef)def);
        } else if (def instanceof LabelDef) {
            this.traverse((LabelDef)def);
        }
    }

    private void traverse(PackageDef pkg) {
        this.handlePackage(pkg);
        this.traversePackage(pkg);
    }

    private void traverse(AnonymousInnerClass innerClass) {
        this.handleAnonymousInnerClass(innerClass);
        this.traverseChildren(innerClass);
    }

    private void traverse(ClassDef classDef) {
        this.handleClass(classDef);
        this.traverseChildren(classDef);
    }

    private void traverse(DefaultConstructor constructor) {
        this.handleDefaultConstructor(constructor);
    }

    private void traverse(MethodDef method) {
        this.handleMethod(method);
        this.traverseChildren(method);
    }

    private void traverse(BlockDef block) {
        this.handleBlock(block);
        this.traverseChildren(block);
    }

    private void traverse(VariableDef variable) {
        this.handleVariable(variable);
    }

    private void traverse(LabelDef label) {
        this.handleLabel(label);
    }

    private void traversePackage(PackageDef pkg) {
        Iterator definitions = pkg.getClasses();
        while (definitions.hasNext()) {
            ClassDef classDef = (ClassDef)definitions.next();
            this.traverse(classDef);
        }
    }

    private void traverseChildren(Scope scope) {
        Enumeration definitions = scope.getDefinitions();
        while (definitions.hasMoreElements()) {
            Definition def = (Definition)definitions.nextElement();
            this.traverse(def);
        }
    }

    protected void handlePackage(PackageDef pkg) {
    }

    protected void handleAnonymousInnerClass(AnonymousInnerClass innerClass) {
    }

    protected void handleClass(ClassDef classDef) {
    }

    protected void handleDefaultConstructor(DefaultConstructor constructor) {
    }

    protected void handleMethod(MethodDef method) {
    }

    protected void handleBlock(BlockDef block) {
    }

    protected void handleVariable(VariableDef variable) {
    }

    protected void handleLabel(LabelDef label) {
    }
}

