/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.BaseScope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.BlockDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.LabelDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.MethodDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.PackageDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Scope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ScopeIndex;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.VariableDef;
import java.io.File;
import java.util.Hashtable;
import java.util.Stack;

public class SymbolTable {
    private Hashtable packages = new Hashtable();
    private Stack scopes = new Stack();
    private ScopeIndex index = new ScopeIndex();
    private File currentFile;
    private BaseScope baseScope;
    private SymTabAST root;

    public SymbolTable(SymTabAST aRoot) {
        this.scopes = new Stack();
        this.root = aRoot;
        this.baseScope = new BaseScope(this);
        this.pushScope(this.baseScope);
    }

    public SymTabAST getTree() {
        return this.root;
    }

    public BaseScope getBaseScope() {
        return this.baseScope;
    }

    public Scope getCurrentScope() {
        return (Scope)this.scopes.peek();
    }

    public void pushScope(Scope scope) {
        this.scopes.push(scope);
    }

    public Scope popScope() {
        Scope scope = (Scope)this.scopes.pop();
        return scope;
    }

    public Hashtable getPackages() {
        return this.packages;
    }

    public PackageDef getPackage(String name) {
        return (PackageDef)this.packages.get(name);
    }

    public void definePackage(PackageDef pkg, Scope parent) {
        parent.addDefinition(pkg);
        this.packages.put(pkg.getQualifiedName(), pkg);
    }

    public void defineClass(ClassDef def) {
        this.indexScope(def);
        this.getCurrentScope().addDefinition(def);
    }

    public void defineMethod(MethodDef method) {
        this.indexScope(method);
        ((ClassDef)this.getCurrentScope()).addDefinition(method);
    }

    public void defineVariable(VariableDef v) {
        this.getCurrentScope().addDefinition(v);
    }

    public void defineBlock(BlockDef blockDef) {
        this.indexScope(blockDef);
        this.getCurrentScope().addDefinition(blockDef);
    }

    public void defineLabel(LabelDef labelDef) {
        this.getCurrentScope().addDefinition(labelDef);
    }

    public void indexScope(Scope scope) {
        this.index.addScope(scope);
    }

    public ScopeIndex getScopeIndex() {
        return this.index;
    }

    public void setCurrentFile(File file) {
        this.currentFile = file;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }
}

