/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import antlr.CommonASTWithHiddenTokens;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ASTManager;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IDefinition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Reference;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Scope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Span;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabASTFactory;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabASTIterator;
import java.io.File;

public class SymTabAST
extends CommonASTWithHiddenTokens {
    private Scope _scope;
    private IDefinition _definition = null;
    private boolean _isMeaningful = true;
    private File _file;
    private int _line;
    private int _column;
    private Span _span;
    private DetailAST detailNode;

    public void setParent(SymTabAST parent) {
    }

    public Scope getScope() {
        return this._scope;
    }

    public void setScope(Scope scope) {
        this._scope = scope;
    }

    public void setDefinition(IDefinition definition, Scope scope) {
        this.setDefinition(definition, scope, true);
    }

    public void setDefinition(IDefinition definition, Scope scope, boolean createReference) {
        this._definition = definition;
        Reference reference = new Reference(this);
        if (scope != null) {
            scope.addReferenceInScope(reference);
        }
        if (definition.isSourced() && createReference) {
            this._definition.addReference(reference);
        }
    }

    public IDefinition getDefinition() {
        return this._definition;
    }

    public boolean isMeaningful() {
        return this._isMeaningful;
    }

    public void setMeaningfulness(boolean isMeaningful) {
        this._isMeaningful = isMeaningful;
    }

    public void ignoreChildren() {
        if (this.getType() == 58) {
            this.setMeaningfulness(false);
        }
        for (SymTabAST child = (SymTabAST)this.getFirstChild(); child != null; child = (SymTabAST)child.getNextSibling()) {
            child.ignoreChildren();
        }
    }

    public void setFile(File file) {
        this._file = file;
    }

    public Span finishDefinition(File file, SymTabAST parent) {
        this.setFile(file);
        this.setParent(parent);
        Span result = this.finishChildren(file);
        if (this.getLineNo() != 0) {
            result.compose(new Span(this.getLineNo(), this.getColumnNo(), this.getLineNo(), this.getColumnNo() + (this.getText() == null ? 0 : this.getText().length() - 1)));
        }
        this.setSpan(result);
        return result;
    }

    public Span finishChildren(File file) {
        Span result = null;
        SymTabAST current = (SymTabAST)this.getFirstChild();
        if (current == null) {
            result = this.getSpan();
        } else {
            while (current != null) {
                Span childSpan = current.finishDefinition(file, this);
                if (childSpan != null) {
                    if (result == null) {
                        result = new Span(childSpan);
                    } else {
                        result.compose(childSpan);
                    }
                }
                current = (SymTabAST)current.getNextSibling();
            }
        }
        return result;
    }

    public File getFile() {
        return this._file;
    }

    public void setLine(int line) {
        this._line = line;
    }

    public int getLineNo() {
        return this._line;
    }

    public void setColumn(int column) {
        this._column = column;
    }

    public int getColumnNo() {
        return this._column;
    }

    public String getName() {
        String result = null;
        if (this._definition != null) {
            result = this._definition.getName();
        }
        return result;
    }

    public String toString() {
        StringBuffer resultBuffer = new StringBuffer(this.prefixString(true));
        resultBuffer.append("[" + this.getLineNo() + "," + this.getColumnNo() + "]");
        resultBuffer.append(" in " + this.getFile());
        return resultBuffer.toString();
    }

    public String prefixString(boolean verboseStringConversion) {
        StringBuffer b = new StringBuffer();
        try {
            String name = TokenTypes.getTokenName((int)this.getType());
            if (verboseStringConversion && !this.getText().equalsIgnoreCase(name)) {
                b.append('[');
                b.append(this.getText());
                b.append(",<");
                b.append(name);
                b.append(">]");
                return b.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getText();
    }

    public Span getSpan() {
        if (this._span == null) {
            int endColumn = this.getColumnNo() + 1;
            String text = this.getText();
            if (text != null) {
                endColumn += text.length() - 1;
            }
            this._span = new Span(this.getLineNo(), this.getColumnNo() + 1, this.getLineNo(), endColumn);
        }
        return this._span;
    }

    public void setSpan(Span span) {
        this._span = span;
    }

    public SymTabAST getEnclosingNode(int line, int column) {
        SymTabAST result = null;
        if (this.getSpan() != null && this.getSpan().contains(line, column)) {
            for (SymTabAST child = (SymTabAST)this.getFirstChild(); child != null && result == null; child = (SymTabAST)child.getNextSibling()) {
                result = child.getEnclosingNode(line, column);
            }
            if (result == null) {
                result = this;
            }
        }
        return result;
    }

    public AST getFirstChild() {
        if (super.getFirstChild() == null) {
            DetailAST childDetailAST = null;
            DetailAST detailAST = this.getDetailNode();
            if (detailAST != null && (childDetailAST = (DetailAST)detailAST.getFirstChild()) != null) {
                SymTabAST child = SymTabASTFactory.create((AST)childDetailAST);
                this.setFirstChild((AST)child);
                child.setParent(this);
                child.setFile(this.getFile());
            }
        }
        return super.getFirstChild();
    }

    public AST getNextSibling() {
        if (super.getNextSibling() == null) {
            DetailAST siblingDetailAST = null;
            DetailAST detailAST = this.getDetailNode();
            if (detailAST != null && (siblingDetailAST = (DetailAST)detailAST.getNextSibling()) != null) {
                SymTabAST sibling = SymTabASTFactory.create((AST)siblingDetailAST);
                this.setNextSibling((AST)sibling);
                sibling.setFile(this.getFile());
            }
        }
        return super.getNextSibling();
    }

    public void initialize(AST aAST) {
        if (aAST != null) {
            super.initialize(aAST);
            DetailAST detailAST = (DetailAST)aAST;
            this.setDetailNode(detailAST);
            this._column = detailAST.getColumnNo() + 1;
            this._line = detailAST.getLineNo();
        }
    }

    public SymTabAST findFirstToken(int type) {
        SymTabAST result = null;
        for (AST sibling = this.getFirstChild(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getType() != type) continue;
            result = (SymTabAST)sibling;
            break;
        }
        return result;
    }

    public SymTabASTIterator getChildren() {
        return new SymTabASTIterator(this);
    }

    public DetailAST getDetailNode() {
        return this.detailNode;
    }

    public void setDetailNode(DetailAST aDetailAST) {
        this.detailNode = aDetailAST;
        ASTManager.getInstance().put((AST)aDetailAST, this);
    }
}

