/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.AnonymousInnerClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ArrayDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.BlockDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.DefinitionTraverser;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.DotIterator;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IDefinition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IMethod;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.LabelDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.LiteralResolver;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.MethodDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.MethodSignature;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.NullClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.PrimitiveClasses;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Scope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabASTIterator;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymbolTable;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.UnknownClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.VariableDef;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class Resolver
extends DefinitionTraverser {
    private boolean mInitialized = false;
    private LogFactory mLogFactory;

    public Resolver(SymbolTable symbolTable) {
        super(symbolTable);
        try {
            this.mLogFactory = LogFactory.getFactory();
        }
        catch (LogConfigurationException e) {
            System.out.println("log configuration exception" + (Object)((Object)e));
        }
        this.mInitialized = true;
    }

    public void resolve() {
        this.traverse();
    }

    protected void handleSList(SymTabAST node, Scope scope) {
        SymTabASTIterator iterator = node.getChildren();
        while (iterator.hasNext()) {
            SymTabAST current = iterator.nextChild();
            this.resolveExpression(current, scope, null, true);
        }
    }

    protected void handleAnonymousInnerClass(AnonymousInnerClass innerClass) {
        SymTabAST objblock = innerClass.getTreeNode();
        for (SymTabAST expression = (SymTabAST)objblock.getFirstChild(); expression != null; expression = (SymTabAST)expression.getNextSibling()) {
            this.resolveExpression(expression, innerClass, null, true);
        }
    }

    protected void handleClass(ClassDef classDef) {
        SymTabAST node = classDef.getTreeNode();
        if (node != null) {
            SymTabAST nameNode = node.findFirstToken(58);
            nameNode.setDefinition(classDef, classDef, true);
            SymTabAST extendsClause = node.findFirstToken(18);
            for (SymTabAST extendedClassNode = (SymTabAST)extendsClause.getFirstChild(); extendedClassNode != null; extendedClassNode = (SymTabAST)extendedClassNode.getNextSibling()) {
                IClass superClass = this.resolveClass(extendedClassNode, classDef, null, true);
                extendedClassNode.setDefinition(superClass, classDef, true);
            }
            SymTabAST implementsNode = node.findFirstToken(19);
            if (implementsNode != null) {
                for (SymTabAST interfaceNode = (SymTabAST)implementsNode.getFirstChild(); interfaceNode != null; interfaceNode = (SymTabAST)interfaceNode.getNextSibling()) {
                    this.resolveClass(interfaceNode, classDef, null, true);
                }
            }
        }
    }

    protected void handleMethod(MethodDef method) {
        SymTabAST slist;
        SymTabAST throwsNode;
        SymTabAST node = method.getTreeNode();
        SymTabAST nameNode = node.findFirstToken(58);
        nameNode.setDefinition(method, method, true);
        SymTabAST returnTypeNode = node.findFirstToken(13);
        if (returnTypeNode != null) {
            this.resolveExpression(returnTypeNode, method, null, true);
        }
        if ((throwsNode = node.findFirstToken(81)) != null) {
            for (SymTabAST exception = (SymTabAST)throwsNode.getFirstChild(); exception != null; exception = (SymTabAST)exception.getNextSibling()) {
                if (exception.getType() == 74) continue;
                this.resolveClass(exception, method, null, true);
            }
        }
        if ((slist = node.findFirstToken(7)) != null) {
            this.handleSList(slist, method);
        }
    }

    protected void handleBlock(BlockDef block) {
        SymTabAST node = block.getTreeNode();
        switch (node.getType()) {
            case 91: {
                this.handleFor(block);
                break;
            }
            case 83: {
                this.handleIf(block);
                break;
            }
            case 84: {
                this.handleWhileAndSynchronized(block);
                break;
            }
            case 85: {
                this.handleDoWhile(block);
                break;
            }
            case 95: 
            case 97: {
                SymTabAST slist = node.findFirstToken(7);
                this.handleSList(slist, block);
                break;
            }
            case 96: {
                this.handleCatch(block);
                break;
            }
            case 89: {
                this.handleSwitch(block);
                break;
            }
            case 7: {
                this.handleSList(node, block);
                break;
            }
            case 28: {
                this.resolveExpression(node, block, null, true);
                break;
            }
            case 11: 
            case 12: {
                this.handleSList((SymTabAST)node.getFirstChild(), block);
                break;
            }
            case 67: {
                this.handleWhileAndSynchronized(block);
                break;
            }
            case 151: {
                this.handleAssert(block);
                break;
            }
            default: {
                if (!this.mInitialized) break;
                Log log = this.mLogFactory.getInstance(this.getClass());
                log.error((Object)("Unhandled block " + block + " of type " + node.getType()));
            }
        }
    }

    private void handleAssert(BlockDef block) {
        SymTabAST message;
        SymTabAST node = block.getTreeNode();
        SymTabAST conditional = node.findFirstToken(28);
        this.resolveExpression(conditional, block, null, true);
        for (message = (SymTabAST)conditional.getNextSibling(); message != null && message.getType() != 28; message = (SymTabAST)message.getNextSibling()) {
        }
        if (message != null) {
            this.resolveExpression(message, block, null, true);
        }
    }

    private void handleSwitch(BlockDef block) {
        SymTabAST caseGroup;
        SymTabAST node = block.getTreeNode();
        SymTabAST expr = node.findFirstToken(28);
        this.resolveExpression(expr, block, null, true);
        for (caseGroup = (SymTabAST)expr.getNextSibling(); caseGroup != null && caseGroup.getType() != 33; caseGroup = (SymTabAST)caseGroup.getNextSibling()) {
        }
        if (caseGroup != null) {
            while (caseGroup.getType() == 33) {
                for (SymTabAST caseNode = caseGroup.findFirstToken(93); caseNode != null && caseNode.getType() == 93; caseNode = (SymTabAST)caseNode.getNextSibling()) {
                    this.resolveExpression((SymTabAST)caseNode.getFirstChild(), block, null, true);
                }
                SymTabAST caseSlist = caseGroup.findFirstToken(7);
                this.handleSList(caseSlist, block);
                caseGroup = (SymTabAST)caseGroup.getNextSibling();
            }
        }
    }

    private void handleCatch(BlockDef block) {
        SymTabAST node = block.getTreeNode();
        SymTabAST slist = node.findFirstToken(7);
        this.handleSList(slist, block);
    }

    private void handleFor(BlockDef block) {
        SymTabAST body;
        SymTabAST node = block.getTreeNode();
        SymTabAST forEach = node.findFirstToken(156);
        if (forEach == null) {
            SymTabAST iterator;
            SymTabAST cond;
            SymTabAST init = node.findFirstToken(35);
            if (init.getFirstChild() != null && init.getFirstChild().getType() == 34) {
                this.resolveExpression((SymTabAST)init.getFirstChild(), block, null, true);
            }
            if ((cond = node.findFirstToken(36)).getFirstChild() != null) {
                this.resolveExpression((SymTabAST)cond.getFirstChild(), block, null, true);
            }
            if ((iterator = node.findFirstToken(37)).getFirstChild() != null) {
                this.resolveExpression((SymTabAST)iterator.getFirstChild(), block, null, true);
            }
            body = (SymTabAST)iterator.getNextSibling();
        } else {
            this.resolveExpression(forEach.findFirstToken(28), block, null, true);
            body = (SymTabAST)forEach.getNextSibling();
        }
        if (body.getType() == 77) {
            body = (SymTabAST)body.getNextSibling();
        }
        if (body.getType() == 7) {
            this.handleSList(body, block);
        } else {
            this.resolveExpression(body, block, null, true);
        }
    }

    private void handleIf(BlockDef block) {
        SymTabAST node = block.getTreeNode();
        SymTabAST conditional = node.findFirstToken(28);
        this.resolveExpression(conditional, block, null, true);
        SymTabAST body = (SymTabAST)conditional.getNextSibling();
        if (body.getType() == 77) {
            body = (SymTabAST)body.getNextSibling();
        }
        if (body != null) {
            SymTabAST elseBody;
            if (body.getType() == 7) {
                this.handleSList(body, block);
            } else {
                this.resolveExpression(body, block, null, true);
            }
            for (elseBody = (SymTabAST)body.getNextSibling(); elseBody != null && elseBody.getType() != 92; elseBody = (SymTabAST)elseBody.getNextSibling()) {
            }
            if (elseBody != null) {
                elseBody = (SymTabAST)elseBody.getFirstChild();
            }
            if (elseBody != null) {
                this.resolveExpression(elseBody, block.getParentScope(), null, true);
            }
        }
    }

    private void handleWhileAndSynchronized(BlockDef block) {
        SymTabAST node = block.getTreeNode();
        SymTabAST condition = node.findFirstToken(28);
        SymTabAST slist = (SymTabAST)condition.getNextSibling();
        if (slist.getType() == 77) {
            slist = (SymTabAST)slist.getNextSibling();
        }
        this.resolveExpression(condition, block, null, true);
        this.handleSList(slist, block);
    }

    private void handleDoWhile(BlockDef block) {
        SymTabAST node = block.getTreeNode();
        SymTabAST slist = (SymTabAST)node.getFirstChild();
        SymTabAST condition = node.findFirstToken(28);
        this.handleSList(slist, block);
        this.resolveExpression(condition, block, null, true);
    }

    protected void handleVariable(VariableDef variable) {
        SymTabAST node = variable.getTreeNode();
        Scope location = variable.getParentScope();
        SymTabAST nameNode = node.findFirstToken(58);
        nameNode.setDefinition(variable, location, true);
        SymTabAST typeNode = node.findFirstToken(13);
        this.resolveType(typeNode, location, null, true);
        SymTabAST assignmentNode = node.findFirstToken(80);
        if (assignmentNode != null) {
            this.resolveExpression((SymTabAST)assignmentNode.getFirstChild(), variable.getParentScope(), null, true);
        }
    }

    protected void handleLabel(LabelDef label) {
        SymTabAST node = label.getTreeNode();
        ((SymTabAST)node.getFirstChild()).setDefinition(label, label.getParentScope(), true);
    }

    public IClass resolveExpression(SymTabAST expression, Scope location, IClass context, boolean referencePhase) {
        IClass result = null;
        try {
            switch (expression.getType()) {
                case 23: {
                    result = this.resolveTypecast(expression, location, context, referencePhase);
                    break;
                }
                case 28: 
                case 88: {
                    if (expression.getFirstChild() != null) {
                        result = this.resolveExpression((SymTabAST)expression.getFirstChild(), location, context, referencePhase);
                    }
                    break;
                }
                case 34: {
                    for (SymTabAST child = (SymTabAST)expression.getFirstChild(); child != null; child = (SymTabAST)child.getNextSibling()) {
                        if (child.getType() == 74) continue;
                        this.resolveExpression(child, location, context, referencePhase);
                    }
                    break;
                }
                case 58: {
                    result = this.resolveIdent(expression, location, context, referencePhase);
                    break;
                }
                case 13: {
                    result = this.resolveType(expression, location, context, referencePhase);
                    break;
                }
                case 27: {
                    result = this.resolveMethod(expression, location, context, referencePhase);
                    break;
                }
                case 78: {
                    result = this.resolveLiteralThis(expression, location, context);
                    break;
                }
                case 79: {
                    result = this.resolveLiteralSuper(expression, location, context);
                    break;
                }
                case 59: {
                    result = this.resolveDottedName(expression, location, context, referencePhase);
                    break;
                }
                case 42: 
                case 43: 
                case 136: {
                    result = this.resolveNew(expression, location, context, referencePhase);
                    break;
                }
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    result = this.resolvePrimitiveType(expression, location, context, referencePhase);
                    break;
                }
                case 137: 
                case 141: {
                    result = this.resolveNumInt(expression, location, context);
                    break;
                }
                case 140: 
                case 142: {
                    result = this.resolveNumFloat(expression, location, context);
                    break;
                }
                case 139: {
                    result = this.resolveStringLiteral(expression, location, context);
                    break;
                }
                case 138: {
                    result = this.resolveCharLiteral(expression, location, context);
                    break;
                }
                case 80: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: {
                    this.resolveAssignment(expression, location, context, referencePhase);
                    break;
                }
                case 110: 
                case 111: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    result = this.resolveBooleanExpression(expression, location, context, referencePhase);
                    break;
                }
                case 121: {
                    result = this.resolveInstanceOf(expression, location, context, referencePhase);
                    break;
                }
                case 133: 
                case 134: {
                    result = this.resolveBooleanLiteral(expression, location, context);
                    break;
                }
                case 132: {
                    result = this.resolveBooleanUnary(expression, location, context, referencePhase);
                    break;
                }
                case 25: 
                case 26: 
                case 31: 
                case 32: 
                case 129: 
                case 130: {
                    result = this.resolveUnaryExpression(expression, location, context, referencePhase);
                    break;
                }
                case 60: 
                case 112: 
                case 113: 
                case 114: 
                case 125: 
                case 126: 
                case 127: 
                case 128: {
                    result = this.resolveArithmeticExpression(expression, location, context, referencePhase);
                    break;
                }
                case 86: 
                case 87: {
                    this.resolveGoto(expression, location, context, referencePhase);
                    break;
                }
                case 76: {
                    result = this.resolveExpression((SymTabAST)expression.getNextSibling(), location, context, referencePhase);
                    break;
                }
                case 24: {
                    result = this.resolveArrayAccess(expression, location, context, referencePhase);
                    break;
                }
                case 135: {
                    result = new NullClass();
                    break;
                }
                case 109: {
                    result = this.resolveQuestion(expression, location, context, referencePhase);
                    break;
                }
                case 69: {
                    result = this.resolveLiteralClass();
                    break;
                }
                case 29: {
                    this.resolveArrayInitializer(expression, location, context, referencePhase);
                    break;
                }
                case 90: {
                    this.resolveThrowExpression(expression, location, context, referencePhase);
                    break;
                }
                case 122: 
                case 123: 
                case 124: {
                    result = this.resolveShiftOperator(expression, location, context, referencePhase);
                    break;
                }
                case 131: {
                    this.resolveBitwiseNot(expression, location, context, referencePhase);
                    break;
                }
                case 151: {
                    break;
                }
                case 7: 
                case 9: 
                case 10: 
                case 14: 
                case 17: 
                case 22: 
                case 38: 
                case 45: 
                case 49: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 83: 
                case 84: 
                case 85: 
                case 89: 
                case 91: 
                case 95: 
                case 96: 
                case 97: {
                    break;
                }
                default: {
                    if (this.mInitialized) {
                        Log log = this.mLogFactory.getInstance(this.getClass());
                        log.error((Object)("Unhandled expression type: " + expression.getType()));
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            result = new UnknownClass(expression.getText(), expression);
        }
        return result;
    }

    private IClass resolveTypecast(SymTabAST node, Scope location, IClass context, boolean referencePhase) {
        SymTabAST typeNode = (SymTabAST)node.getFirstChild();
        SymTabAST exprNode = (SymTabAST)typeNode.getNextSibling();
        if (exprNode.getType() == 77) {
            exprNode = (SymTabAST)exprNode.getNextSibling();
        }
        IClass type = null;
        SymTabAST child = (SymTabAST)typeNode.getFirstChild();
        boolean createReference = false;
        type = child.getType() == 17 ? new ArrayDef(this.resolveType((SymTabAST)typeNode.getFirstChild(), location, context, false)) : this.resolveType(typeNode, location, context, false);
        this.resolveExpression(exprNode, location, context, referencePhase);
        if (type != null) {
            ((SymTabAST)typeNode.getFirstChild()).setDefinition(type, location, referencePhase);
        }
        return type;
    }

    private IClass resolveArrayAccess(SymTabAST node, Scope location, IClass context, boolean referencePhase) {
        SymTabAST arrayNode = (SymTabAST)node.getFirstChild();
        SymTabAST exprNode = (SymTabAST)arrayNode.getNextSibling();
        while (arrayNode.getType() == 24) {
            this.resolveExpression(exprNode, location, context, referencePhase);
            arrayNode = (SymTabAST)arrayNode.getFirstChild();
            exprNode = (SymTabAST)arrayNode.getNextSibling();
        }
        ArrayDef array = (ArrayDef)this.resolveExpression(arrayNode, location, context, referencePhase);
        this.resolveExpression(exprNode, location, context, referencePhase);
        return array.getType();
    }

    private IClass resolveLiteralClass() {
        return new ExternalClass(Class.class);
    }

    private IClass resolveDottedName(SymTabAST tree, Scope location, IClass context, boolean referencePhase) {
        IClass result = null;
        IClass localContext = context;
        String name = null;
        DotIterator it = new DotIterator(tree);
        while (it.hasNext()) {
            SymTabAST node = it.nextNode();
            if (node.getType() == 74 || (localContext = this.resolveExpression(node, location, localContext, referencePhase)) != null) continue;
            node.setMeaningfulness(false);
            name = node.getText();
            while (localContext == null && it.hasNext()) {
                SymTabAST next = it.nextNode();
                localContext = location.getClassDefinition(name = name + "." + next.getText());
                if (localContext != null && referencePhase) {
                    next.setDefinition(localContext, location, referencePhase);
                    continue;
                }
                next.setMeaningfulness(false);
            }
        }
        result = localContext != null ? localContext : new UnknownClass(name, tree);
        return result;
    }

    private IClass resolveMethod(SymTabAST methodNode, Scope location, IClass context, boolean referencePhase) {
        IMethod method;
        IClass result = new UnknownClass(methodNode.getText(), methodNode);
        IClass newContext = null;
        newContext = context == null ? location.getEnclosingClass() : context;
        String name = null;
        boolean createReference = true;
        SymTabAST nameNode = (SymTabAST)methodNode.getFirstChild();
        SymTabAST parametersNode = (SymTabAST)nameNode.getNextSibling();
        MethodSignature signature = this.resolveParameters(parametersNode, location, context, referencePhase);
        if (nameNode.getType() == 58) {
            name = nameNode.getText();
        } else if (nameNode.getType() == 79 || nameNode.getType() == 42) {
            IClass superclass;
            newContext = superclass = location.getEnclosingClass().getSuperclass();
            name = superclass.getName();
            createReference = false;
        } else if (nameNode.getType() == 78) {
            newContext = location.getEnclosingClass();
            name = newContext.getName();
            createReference = false;
        } else {
            SymTabAST contextNode = (SymTabAST)nameNode.getFirstChild();
            nameNode = (SymTabAST)contextNode.getNextSibling();
            while (nameNode.getType() != 58) {
                nameNode = (SymTabAST)nameNode.getNextSibling();
            }
            name = nameNode.getText();
            newContext = this.resolveExpression(contextNode, location, context, referencePhase);
        }
        if (newContext != null && (method = newContext.getMethodDefinition(name, signature)) != null) {
            if (createReference && referencePhase) {
                nameNode.setDefinition(method, location, referencePhase);
            }
            result = method.getType();
        }
        if (result == null) {
            result = new UnknownClass(methodNode.getText(), methodNode);
        }
        return result;
    }

    private IClass resolveLiteralThis(SymTabAST thisNode, Scope location, IClass context) {
        return location.getEnclosingClass();
    }

    private IClass resolveLiteralSuper(SymTabAST superNode, Scope location, IClass context) {
        return location.getEnclosingClass().getSuperclass();
    }

    private boolean newIsConstructor(SymTabAST newNode) {
        boolean result = false;
        SymTabAST typeNode = (SymTabAST)newNode.getFirstChild().getNextSibling();
        if (typeNode.getType() == 76) {
            typeNode = (SymTabAST)typeNode.getNextSibling();
        }
        if (typeNode.getType() == 34) {
            result = true;
        }
        return result;
    }

    public IClass resolveType(SymTabAST expr, Scope location, IClass context, boolean referencePhase) {
        IClass result = null;
        SymTabAST nameNode = (SymTabAST)expr.getFirstChild();
        boolean createReference = false;
        result = nameNode.getType() == 59 ? this.resolveDottedName(nameNode, location, context, false) : this.resolveClassIdent(nameNode, location, context, false);
        return result;
    }

    public IClass resolveClass(SymTabAST expr, Scope location, IClass context, boolean referencePhase) {
        IClass result = this.resolveDottedName(expr, location, context, referencePhase);
        if (result != null && referencePhase) {
            expr.setDefinition(result, location, referencePhase);
        }
        return result;
    }

    public IClass resolveClassIdent(SymTabAST expr, Scope location, IClass context, boolean referencePhase) {
        IClass result = location.getClassDefinition(expr.getText());
        if (result != null) {
            expr.setDefinition(result, location, referencePhase);
        }
        return result;
    }

    private IClass resolveNew(SymTabAST newNode, Scope location, IClass context, boolean referencePhase) {
        IClass result = this.newIsConstructor(newNode) ? this.resolveConstructor(newNode, location, context, referencePhase) : this.resolveNewArray(newNode, location, context, referencePhase);
        return result;
    }

    private IClass resolveNewArray(SymTabAST newNode, Scope location, IClass context, boolean referencePhase) {
        SymTabAST typeNode = (SymTabAST)newNode.getFirstChild();
        SymTabAST declaratorNode = (SymTabAST)typeNode.getNextSibling();
        SymTabAST initializerNode = (SymTabAST)declaratorNode.getNextSibling();
        IClass arrayType = this.resolveClass(typeNode, location, context, referencePhase);
        if (declaratorNode.getFirstChild() != null) {
            this.resolveExpression((SymTabAST)declaratorNode.getFirstChild(), location, context, referencePhase);
        }
        if (initializerNode != null) {
            this.resolveArrayInitializer(initializerNode, location, context, referencePhase);
        }
        return new ArrayDef(arrayType);
    }

    private IClass resolveQuestion(SymTabAST question, Scope location, IClass context, boolean referencePhase) {
        SymTabAST test = (SymTabAST)question.getFirstChild();
        while (test.getType() == 76) {
            test = (SymTabAST)test.getNextSibling();
        }
        SymTabAST leftBranch = (SymTabAST)test.getNextSibling();
        while (leftBranch.getType() == 77) {
            leftBranch = (SymTabAST)leftBranch.getNextSibling();
        }
        SymTabAST rightBranch = (SymTabAST)leftBranch.getNextSibling();
        while (rightBranch.getType() != 82) {
            rightBranch = (SymTabAST)rightBranch.getNextSibling();
        }
        rightBranch = (SymTabAST)rightBranch.getNextSibling();
        this.resolveExpression(test, location, context, referencePhase);
        IClass leftClass = this.resolveExpression(leftBranch, location, context, referencePhase);
        IClass rightClass = this.resolveExpression(rightBranch, location, context, referencePhase);
        return this.moreGeneral(leftClass, rightClass);
    }

    private IClass moreGeneral(IClass a, IClass b) {
        return a.isCompatibleWith(b) ? b : a;
    }

    private IClass resolveConstructor(SymTabAST constructor, Scope location, IClass context, boolean referencePhase) {
        IClass classConstructed = null;
        SymTabAST nameNode = (SymTabAST)constructor.getFirstChild();
        SymTabAST parametersNode = constructor.findFirstToken(34);
        SymTabAST nameIdent = null;
        nameIdent = nameNode.getType() == 58 ? nameNode : (SymTabAST)nameNode.getFirstChild().getNextSibling();
        classConstructed = this.resolveClass(nameNode, location, context, false);
        if (classConstructed != null) {
            MethodSignature signature = this.resolveParameters(parametersNode, location, context, referencePhase);
            IMethod constructorDef = classConstructed.getMethodDefinition(nameIdent.getText(), signature);
            if (constructorDef != null && referencePhase) {
                nameIdent.setDefinition(constructorDef, location, referencePhase);
            }
        }
        return classConstructed;
    }

    private MethodSignature resolveParameters(SymTabAST elist, Scope location, IClass context, boolean referencePhase) {
        Vector<IClass> parameters = new Vector<IClass>();
        for (SymTabAST expr = (SymTabAST)elist.getFirstChild(); expr != null; expr = (SymTabAST)expr.getNextSibling()) {
            if (expr.getType() == 74) continue;
            IClass parameter = this.resolveExpression((SymTabAST)expr.getFirstChild(), location, context, referencePhase);
            parameters.add(parameter);
        }
        return new MethodSignature(parameters);
    }

    private IClass resolveIdent(SymTabAST ident, Scope location, IClass context, boolean referencePhase) {
        IClass result = null;
        IDefinition def = null;
        String name = ident.getText();
        def = context != null ? context.getVariableDefinition(name) : location.getVariableDefinition(name);
        if (def != null) {
            result = def.getType();
        } else {
            result = context != null ? context.getClassDefinition(name) : location.getClassDefinition(name);
            def = result;
        }
        if (def != null) {
            ident.setDefinition(def, location, referencePhase);
        }
        return result;
    }

    private IClass resolveBooleanExpression(SymTabAST expression, Scope location, IClass context, boolean referencePhase) {
        IClass result = null;
        SymTabAST leftChild = this.findLeftChild(expression);
        this.resolveExpression(leftChild, location, context, referencePhase);
        SymTabAST rightChild = this.findRightSibling(leftChild);
        this.resolveExpression(rightChild, location, context, referencePhase);
        result = LiteralResolver.getDefinition(50);
        return result;
    }

    private IClass resolveAssignment(SymTabAST expression, Scope location, IClass context, boolean referencePhase) {
        IClass result = null;
        SymTabAST leftNode = (SymTabAST)expression.getFirstChild();
        SymTabAST rightNode = (SymTabAST)leftNode.getNextSibling();
        result = this.resolveExpression(leftNode, location, context, referencePhase);
        this.resolveExpression(rightNode, location, context, referencePhase);
        return result;
    }

    private IClass resolveUnaryExpression(SymTabAST expression, Scope location, IClass context, boolean referencePhase) {
        SymTabAST operatee = (SymTabAST)expression.getFirstChild();
        return this.resolveExpression(operatee, location, context, referencePhase);
    }

    private IClass resolveArithmeticExpression(SymTabAST expression, Scope location, IClass context, boolean referencePhase) {
        IClass result = null;
        SymTabAST leftChild = this.findLeftChild(expression);
        IClass leftType = this.resolveExpression(leftChild, location, context, referencePhase);
        SymTabAST rightChild = this.findRightSibling(leftChild);
        IClass rightType = this.resolveExpression(rightChild, location, context, referencePhase);
        result = this.binaryResultType(leftType, rightType);
        return result;
    }

    private SymTabAST findLeftChild(SymTabAST aExpression) {
        SymTabAST leftChild = (SymTabAST)aExpression.getFirstChild();
        while (leftChild.getType() == 76) {
            leftChild = (SymTabAST)leftChild.getNextSibling();
        }
        return leftChild;
    }

    private SymTabAST findRightSibling(SymTabAST aLeftChild) {
        SymTabAST rightChild;
        for (rightChild = (SymTabAST)aLeftChild.getNextSibling(); rightChild != null && rightChild.getType() == 77; rightChild = (SymTabAST)rightChild.getNextSibling()) {
        }
        return rightChild;
    }

    private IClass binaryResultType(IClass a, IClass b) {
        IClass result = null;
        ExternalClass string = new ExternalClass(String.class);
        result = a.equals(string) || b.equals(string) ? string : (a.equals(PrimitiveClasses.BOOLEAN) ? PrimitiveClasses.BOOLEAN : PrimitiveClasses.binaryPromote(a, b));
        return result;
    }

    private IClass resolveInstanceOf(SymTabAST expression, Scope location, IClass context, boolean referencePhase) {
        SymTabAST leftNode = (SymTabAST)expression.getFirstChild();
        SymTabAST rightNode = (SymTabAST)leftNode.getNextSibling();
        this.resolveExpression(leftNode, location, context, referencePhase);
        SymTabAST classNameNode = (SymTabAST)rightNode.getFirstChild();
        this.resolveClass(classNameNode, location, context, referencePhase);
        return LiteralResolver.getDefinition(50);
    }

    private IClass resolveGoto(SymTabAST expression, Scope location, IClass context, boolean referencePhase) {
        LabelDef def;
        SymTabAST label = (SymTabAST)expression.getFirstChild();
        if (label != null && label.getType() != 45 && (def = location.getLabelDefinition(label.getText())) != null) {
            label.setDefinition(def, location, referencePhase);
        }
        return null;
    }

    private IClass resolvePrimitiveType(SymTabAST primitive, Scope location, IClass context, boolean referencePhase) {
        IClass result = LiteralResolver.getDefinition(primitive.getType());
        primitive.setDefinition(result, location, referencePhase);
        return result;
    }

    private IClass resolveNumInt(SymTabAST expression, Scope location, IClass context) {
        return PrimitiveClasses.INT;
    }

    private IClass resolveNumFloat(SymTabAST expression, Scope location, IClass context) {
        return PrimitiveClasses.DOUBLE;
    }

    private IClass resolveStringLiteral(SymTabAST expression, Scope location, IClass context) {
        return LiteralResolver.getDefinition(139);
    }

    private IClass resolveCharLiteral(SymTabAST expression, Scope location, IClass context) {
        return LiteralResolver.getDefinition(52);
    }

    private IClass resolveBooleanLiteral(SymTabAST expression, Scope location, IClass context) {
        return LiteralResolver.getDefinition(50);
    }

    private IClass resolveBooleanUnary(SymTabAST expression, Scope location, IClass context, boolean referencePhase) {
        SymTabAST child = (SymTabAST)expression.getFirstChild();
        this.resolveExpression(child, location, context, referencePhase);
        return LiteralResolver.getDefinition(50);
    }

    private void resolveArrayInitializer(SymTabAST initializerNode, Scope location, IClass context, boolean referencePhase) {
        for (SymTabAST child = (SymTabAST)initializerNode.getFirstChild(); child != null; child = (SymTabAST)child.getNextSibling()) {
            if (child.getType() == 74) continue;
            this.resolveExpression(child, location, context, referencePhase);
        }
    }

    private void resolveThrowExpression(SymTabAST throwNode, Scope location, IClass context, boolean referencePhase) {
        SymTabAST nameNode = (SymTabAST)throwNode.getFirstChild();
        this.resolveExpression(nameNode, location, context, referencePhase);
    }

    private IClass resolveShiftOperator(SymTabAST expression, Scope location, IClass context, boolean referencePhase) {
        IClass result = null;
        SymTabAST leftChild = this.findLeftChild(expression);
        SymTabAST rightChild = this.findRightSibling(leftChild);
        result = this.resolveExpression(leftChild, location, context, referencePhase);
        this.resolveExpression(rightChild, location, context, referencePhase);
        result = PrimitiveClasses.unaryPromote(result);
        return result;
    }

    private IClass resolveBitwiseNot(SymTabAST expression, Scope location, IClass context, boolean referencePhase) {
        IClass result = null;
        SymTabAST child = (SymTabAST)expression.getFirstChild();
        result = this.resolveExpression(child, location, context, referencePhase);
        result = PrimitiveClasses.unaryPromote(result);
        return result;
    }
}

