/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ISignature;
import java.util.Arrays;
import java.util.Vector;

public class MethodSignature
implements ISignature {
    private IClass[] _argTypes = null;

    public MethodSignature(IClass[] argTypes) {
        this._argTypes = argTypes;
    }

    public MethodSignature(Vector argTypes) {
        this._argTypes = new IClass[argTypes.size()];
        argTypes.toArray(this._argTypes);
    }

    public IClass[] getParameters() {
        return this._argTypes;
    }

    public boolean isCompatibleWith(ISignature signature) {
        boolean result = true;
        IClass[] comparedArgTypes = signature.getParameters();
        if (this._argTypes.length != comparedArgTypes.length) {
            result = false;
        } else {
            for (int i = 0; i < this._argTypes.length; ++i) {
                if (this._argTypes[i] == null || this._argTypes[i].isCompatibleWith(comparedArgTypes[i])) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean isSame(ISignature signature) {
        return this.equals(signature);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof MethodSignature) {
            MethodSignature signature = (MethodSignature)o;
            result = Arrays.equals(this.getParameters(), signature.getParameters());
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("(");
        for (int i = 0; i < this._argTypes.length; ++i) {
            result.append(this._argTypes[i] != null ? this._argTypes[i].getName() : "[null]");
            if (i >= this._argTypes.length - 1) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }
}

