/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ArrayDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ISignature;
import java.util.Arrays;

public class ExternalSignature
implements ISignature {
    private IClass[] _parameters;

    public ExternalSignature(Class[] parameters) {
        this._parameters = new IClass[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            this._parameters[i] = parameters[i].isArray() ? new ArrayDef(new ExternalClass(parameters[i].getComponentType())) : new ExternalClass(parameters[i]);
        }
    }

    public boolean isCompatibleWith(ISignature signature) {
        boolean result = true;
        if (this._parameters.length == signature.getParameters().length) {
            for (int i = 0; i < this._parameters.length; ++i) {
                if (this.getParameters()[i].isCompatibleWith(signature.getParameters()[i])) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    public boolean isSame(ISignature signature) {
        return Arrays.equals(this._parameters, signature.getParameters());
    }

    public IClass[] getParameters() {
        return this._parameters;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(");
        for (int i = 0; i < this._parameters.length; ++i) {
            result.append(this._parameters[i]);
            if (i >= this._parameters.length - 1) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }
}

