/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import java.io.File;

public class ASTUtil {
    public static int getLine(SymTabAST tree) {
        SymTabAST indexedNode = tree;
        if (indexedNode.getLineNo() == 0) {
            for (indexedNode = (SymTabAST)indexedNode.getFirstChild(); indexedNode != null && indexedNode.getLineNo() == 0; indexedNode = (SymTabAST)indexedNode.getNextSibling()) {
            }
            if (indexedNode == null) {
                indexedNode = tree;
            }
        }
        return indexedNode.getLineNo();
    }

    public static int getColumn(SymTabAST tree) {
        SymTabAST indexedNode = tree;
        if (indexedNode.getColumnNo() == 0 || indexedNode.getType() == 22) {
            for (indexedNode = (SymTabAST)indexedNode.getFirstChild(); indexedNode != null && indexedNode.getColumnNo() == 0; indexedNode = (SymTabAST)indexedNode.getNextSibling()) {
            }
            if (indexedNode == null) {
                indexedNode = tree;
            }
        }
        return indexedNode.getColumnNo();
    }

    public static String constructDottedName(SymTabAST tree) {
        String result;
        if (tree.getType() == 59) {
            SymTabAST left = (SymTabAST)tree.getFirstChild();
            SymTabAST right = (SymTabAST)left.getNextSibling();
            result = ASTUtil.constructDottedName(left) + "." + ASTUtil.constructDottedName(right);
        } else if (tree.getType() == 17) {
            StringBuffer buf = new StringBuffer();
            SymTabAST left = (SymTabAST)tree.getFirstChild();
            SymTabAST right = (SymTabAST)left.getNextSibling();
            buf.append(ASTUtil.constructDottedName(left));
            if (right != null) {
                buf.append(".");
                buf.append(ASTUtil.constructDottedName(right));
            }
            buf.append(" []");
            result = buf.toString();
        } else {
            result = tree.getType() == 27 ? ASTUtil.constructDottedName((SymTabAST)tree.getFirstChild()) + "()" : tree.getText();
        }
        return result;
    }

    public static String constructPackage(SymTabAST tree) {
        String fullName = ASTUtil.constructDottedName(tree);
        return fullName.substring(0, fullName.lastIndexOf("."));
    }

    public static String constructClass(SymTabAST tree) {
        String fullName = ASTUtil.constructDottedName(tree);
        return fullName.substring(fullName.lastIndexOf(".") + 1, fullName.length());
    }

    public static boolean treesBelowFilesAreEqual(SymTabAST firstRoot, File[] firstFiles, SymTabAST secondRoot, File[] secondFiles) {
        boolean result = true;
        if (firstFiles.length == secondFiles.length) {
            for (int i = 0; i < firstFiles.length; ++i) {
                SymTabAST secondTree;
                SymTabAST firstTree = (SymTabAST)ASTUtil.getFileNode(firstRoot, firstFiles[i]).getFirstChild();
                if (firstTree.equalsList((AST)(secondTree = (SymTabAST)ASTUtil.getFileNode(secondRoot, secondFiles[i]).getFirstChild()))) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static SymTabAST getFileNode(SymTabAST root, File file) {
        SymTabAST result = null;
        for (SymTabAST fileNode = (SymTabAST)root.getFirstChild(); fileNode != null && result == null; fileNode = (SymTabAST)fileNode.getNextSibling()) {
            if (!file.equals(fileNode.getFile())) continue;
            result = fileNode;
        }
        return result;
    }
}

