/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ASTManager;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassManager;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Definition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymbolTableException;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public abstract class AbstractUsageCheck
extends Check {
    private Pattern mRegexp;
    private String mIgnoreFormat;

    public AbstractUsageCheck() {
        this.setIgnoreFormat("^$");
    }

    public void setIgnoreFormat(String aFormat) throws ConversionException {
        try {
            this.mRegexp = Utils.getPattern((String)aFormat);
            this.mIgnoreFormat = aFormat;
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public Pattern getRegexp() {
        return this.mRegexp;
    }

    public String getIgnoreFormat() {
        return this.mIgnoreFormat;
    }

    public void beginTree(DetailAST aRootAST) {
        ClassManager.setClassLoader(this.getClassLoader());
        String fileName = this.getFileContents().getFilename();
        this.getASTManager().addTree(fileName, (AST)aRootAST);
    }

    public void visitToken(DetailAST aAST) {
        if (this.mustCheckReferenceCount(aAST)) {
            DetailAST nameAST = aAST.findFirstToken(58);
            Pattern regexp = this.getRegexp();
            if (regexp == null || !regexp.matcher(nameAST.getText()).find()) {
                this.getASTManager().registerCheckNode(this, (AST)nameAST);
            }
        }
    }

    public void finishTree(DetailAST aAST) {
        if (aAST == null) {
            return;
        }
        try {
            Set nodes = this.getASTManager().getCheckNodes(this);
            if (nodes != null) {
                this.applyTo(nodes);
            }
        }
        catch (SymbolTableException ste) {
            this.logError(ste);
        }
        this.getASTManager().removeCheck(this);
    }

    public void logError(Exception aException) {
        this.log(0, "general.exception", new String[]{aException.getMessage()});
        Utils.getExceptionLogger().debug((Object)"An exception occured.", (Throwable)aException);
    }

    private int getReferenceCount(DetailAST aAST) {
        SymTabAST ident = this.getASTManager().get((AST)aAST);
        if (ident == null) {
            return 0;
        }
        Definition definition = (Definition)ident.getDefinition();
        if (definition != null) {
            return definition.getNumReferences();
        }
        return 0;
    }

    public abstract String getErrorKey();

    public abstract boolean mustCheckReferenceCount(DetailAST var1);

    public void applyTo(Set aNodes) {
        Iterator it = aNodes.iterator();
        while (it.hasNext()) {
            DetailAST nameAST = (DetailAST)it.next();
            if (this.getReferenceCount(nameAST) != 1) continue;
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), this.getErrorKey(), nameAST.getText());
        }
    }

    protected ASTManager getASTManager() {
        return ASTManager.getInstance();
    }
}

