/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ArrayDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalDefinition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalSignature;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IMethod;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ISignature;
import java.lang.reflect.Method;

public class ExternalMethod
extends ExternalDefinition
implements IMethod {
    private Method _javaMethod;
    private ISignature _signature;

    public ExternalMethod(Method javaMethod) {
        this._javaMethod = javaMethod;
        this._signature = new ExternalSignature(this._javaMethod.getParameterTypes());
    }

    public String getName() {
        return this._javaMethod.getName();
    }

    public IClass getType() {
        IClass result = null;
        result = this._javaMethod.getReturnType().isArray() ? new ArrayDef(new ExternalClass(this._javaMethod.getReturnType().getComponentType())) : new ExternalClass(this._javaMethod.getReturnType());
        return result;
    }

    public ISignature getSignature() {
        return this._signature;
    }

    public boolean hasSameSignature(ISignature signature) {
        return this._signature.isSame(signature);
    }

    public boolean hasCompatibleSignature(ISignature signature) {
        return signature.isCompatibleWith(this.getSignature());
    }

    public String getQualifiedName() {
        return this.getName() + this.getSignature();
    }

    public Method getJavaMethod() {
        return this._javaMethod;
    }

    public IClass[] getExceptions() {
        Class<?>[] javaExceptions = this.getJavaMethod().getExceptionTypes();
        IClass[] result = new IClass[javaExceptions.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ExternalClass(javaExceptions[i]);
        }
        return result;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof ExternalMethod) {
            ExternalMethod compared = (ExternalMethod)o;
            result = this.getJavaMethod().equals(compared.getJavaMethod());
        }
        return result;
    }

    public int hashCode() {
        return this.getJavaMethod().hashCode();
    }
}

