/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.usage.AbstractUsageCheck;

public class UnusedPrivateMethodCheck
extends AbstractUsageCheck {
    private boolean mAllowSerializationMethods;

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public String getErrorKey() {
        return "unused.method";
    }

    public void setAllowSerializationMethods(boolean aFlag) {
        this.mAllowSerializationMethods = aFlag;
    }

    public boolean mustCheckReferenceCount(DetailAST aAST) {
        DetailAST mods = aAST.findFirstToken(5);
        if (mods == null || ScopeUtils.getScopeFromMods((DetailAST)mods) != Scope.PRIVATE) {
            return false;
        }
        return !this.mAllowSerializationMethods || !this.isWriteObject(aAST) && !this.isReadObject(aAST) && !this.isWriteReplaceOrReadResolve(aAST);
    }

    private boolean isWriteObject(DetailAST aAST) {
        DetailAST ident = aAST.findFirstToken(58);
        if (!"writeObject".equals(ident.getText())) {
            return false;
        }
        DetailAST typeAST = (DetailAST)aAST.findFirstToken(13).getFirstChild();
        if (typeAST.getType() != 49) {
            return false;
        }
        DetailAST params = aAST.findFirstToken(20);
        if (params == null || params.getChildCount() != 1) {
            return false;
        }
        DetailAST type = (DetailAST)((DetailAST)params.getFirstChild()).findFirstToken(13).getFirstChild();
        String typeName = FullIdent.createFullIdent((DetailAST)type).getText();
        if (!"java.io.ObjectOutputStream".equals(typeName) && !"ObjectOutputStream".equals(typeName)) {
            return false;
        }
        DetailAST throwsAST = aAST.findFirstToken(81);
        if (throwsAST == null || throwsAST.getChildCount() != 1) {
            return false;
        }
        DetailAST expt = (DetailAST)throwsAST.getFirstChild();
        String exceptionName = FullIdent.createFullIdent((DetailAST)expt).getText();
        return "java.io.IOException".equals(exceptionName) || "IOException".equals(exceptionName);
    }

    private boolean isReadObject(DetailAST aAST) {
        DetailAST ident = aAST.findFirstToken(58);
        if (!"readObject".equals(ident.getText())) {
            return false;
        }
        DetailAST typeAST = (DetailAST)aAST.findFirstToken(13).getFirstChild();
        if (typeAST.getType() != 49) {
            return false;
        }
        DetailAST params = aAST.findFirstToken(20);
        if (params == null || params.getChildCount() != 1) {
            return false;
        }
        DetailAST type = (DetailAST)((DetailAST)params.getFirstChild()).findFirstToken(13).getFirstChild();
        String typeName = FullIdent.createFullIdent((DetailAST)type).getText();
        if (!"java.io.ObjectInputStream".equals(typeName) && !"ObjectInputStream".equals(typeName)) {
            return false;
        }
        DetailAST throwsAST = aAST.findFirstToken(81);
        if (throwsAST == null || throwsAST.getChildCount() != 3) {
            return false;
        }
        DetailAST excpt1 = (DetailAST)throwsAST.getFirstChild();
        String exception1 = FullIdent.createFullIdent((DetailAST)excpt1).getText();
        String exception2 = FullIdent.createFullIdent((DetailAST)throwsAST.getLastChild()).getText();
        return ("java.io.IOException".equals(exception1) || "IOException".equals(exception1) || "java.io.IOException".equals(exception2) || "IOException".equals(exception2)) && ("java.lang.ClassNotFoundException".equals(exception1) || "ClassNotFoundException".equals(exception1) || "java.lang.ClassNotFoundException".equals(exception2) || "ClassNotFoundException".equals(exception2));
    }

    private boolean isWriteReplaceOrReadResolve(DetailAST aAST) {
        DetailAST ident = aAST.findFirstToken(58);
        if (!"writeReplace".equals(ident.getText()) && !"readResolve".equals(ident.getText())) {
            return false;
        }
        DetailAST typeAST = (DetailAST)aAST.findFirstToken(13).getFirstChild();
        if (typeAST.getType() != 59 && typeAST.getType() != 58) {
            return false;
        }
        DetailAST params = aAST.findFirstToken(20);
        if (params != null && params.getChildCount() != 0) {
            return false;
        }
        DetailAST throwsAST = aAST.findFirstToken(81);
        if (throwsAST == null || throwsAST.getChildCount() != 1) {
            return false;
        }
        DetailAST excpt = (DetailAST)throwsAST.getFirstChild();
        String exception = FullIdent.createFullIdent((DetailAST)excpt).getText();
        return "java.io.ObjectStreamException".equals(exception) || "ObjectStreamException".equals(exception);
    }
}

