/*
 * Decompiled with CFR 0.152.
 */
package com.steelzack.chartizate;

import com.steelzack.chartizate.ChartizateEncodingManager;
import com.steelzack.chartizate.ChartizateFontManager;
import com.steelzack.chartizate.ChartizateImageManager;
import com.steelzack.chartizate.distributions.ChartizateDistribution;
import com.steelzack.chartizate.distributions.ChartizateDistributionType;
import com.steelzack.chartizate.distributions.ChartizateLinearDistribution;
import com.steelzack.chartizate.objects.ChartizateCharacterImg;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class ChartizateManagerCommon<COLOR, FONT> {
    protected final COLOR backgroundColor;
    protected final ChartizateDistribution distribution;
    protected final ChartizateCharacterImg<?>[][] pencelizerBoard;
    protected final ChartizateFontManager<FONT> fontManager;
    protected final ChartizateEncodingManager<FONT> encodingManager;
    protected final ChartizateImageManager<COLOR, FONT> imageManager;
    protected String desinationImagePath;

    public ChartizateManagerCommon(COLOR backgroundColor, int densityPercentage, int rangePercentage, ChartizateDistributionType distributionType, String fontName, int fontSize, Character.UnicodeBlock block, InputStream imageFullStream, String destinationImagePath) throws FileNotFoundException, IOException {
        this.backgroundColor = backgroundColor;
        this.fontManager = this.createFontManager(fontName, fontSize);
        this.encodingManager = this.createEncodingManager(block);
        this.encodingManager.init();
        this.distribution = this.getDistribution(distributionType, densityPercentage, rangePercentage);
        this.imageManager = this.createImageManager(imageFullStream);
        this.desinationImagePath = destinationImagePath;
        int imageHeight = this.imageManager.getImageHeight();
        this.pencelizerBoard = new ChartizateCharacterImg[imageHeight / fontSize][];
    }

    protected ChartizateDistribution getDistribution(ChartizateDistributionType distributionType, int densityPercentage, int rangePercentage) {
        switch (distributionType) {
            case Gaussian: {
                return null;
            }
            case Linear: {
                return new ChartizateLinearDistribution(this.encodingManager.getCharacters(), densityPercentage, rangePercentage);
            }
            case Poisson: {
                return null;
            }
        }
        return null;
    }

    public void generateConvertedImage() throws IOException {
        int imageWidth = this.imageManager.getImageWidth();
        int currentImageIndexX = 0;
        for (int rowIndex = 0; rowIndex < this.pencelizerBoard.length; ++rowIndex) {
            ArrayList<ChartizateCharacterImg<COLOR>> pencelizerRow = new ArrayList<ChartizateCharacterImg<COLOR>>();
            while (currentImageIndexX < imageWidth) {
                Character character = this.distribution.getCharacterFromArray();
                int width = this.fontManager.getCharacterWidth(character.charValue());
                int height = this.fontManager.getCharacterHeight(character.charValue());
                int currentImageIndexY = rowIndex * height;
                COLOR averageColor = this.imageManager.getPartAverageColor(currentImageIndexX, currentImageIndexY, currentImageIndexX + width, currentImageIndexY + height);
                pencelizerRow.add(new ChartizateCharacterImg<COLOR>(averageColor, this.backgroundColor, width, character.charValue()));
                currentImageIndexX += width;
            }
            this.addFullRow(rowIndex, pencelizerRow);
            currentImageIndexX = 0;
        }
        this.imageManager.saveImage(this.pencelizerBoard, this.fontManager, this.desinationImagePath, imageWidth, this.imageManager.getImageHeight());
    }

    abstract ChartizateImageManager<COLOR, FONT> createImageManager(InputStream var1) throws IOException;

    abstract ChartizateEncodingManager<FONT> createEncodingManager(Character.UnicodeBlock var1);

    abstract ChartizateFontManager<FONT> createFontManager(String var1, int var2);

    abstract void addFullRow(int var1, List<ChartizateCharacterImg<COLOR>> var2);
}

