/*
 * Decompiled with CFR 0.152.
 */
package com.steelzack.chartizate;

import com.steelzack.chartizate.ChartizateFontManager;
import com.steelzack.chartizate.objects.ChartizateCharacterImg;
import java.io.IOException;

public abstract class ChartizateImageManager<COLOR, FONT> {
    abstract int getImageWidth();

    abstract int getImageHeight();

    abstract void saveImage(ChartizateCharacterImg<?>[][] var1, ChartizateFontManager<FONT> var2, String var3, int var4, int var5) throws IOException;

    public COLOR getImageAverageColor() {
        int width = this.getImageWidth() - 1;
        int height = this.getImageHeight() - 1;
        return this.getPartAverageColor(0, 0, width, height);
    }

    public COLOR getPartAverageColor(int x0, int y0, int xn, int yn) {
        double alpha = 0.0;
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        for (int j = x0; j <= xn && j < this.getImageWidth(); ++j) {
            for (int k = y0; k <= yn && k < this.getImageHeight(); ++k) {
                int rgbPixel = this.getImagePixelRGB(j, k);
                alpha += (double)this.getAlpha(rgbPixel);
                red += (double)this.getRed(rgbPixel);
                green += (double)this.getGreen(rgbPixel);
                blue += (double)this.getBlue(rgbPixel);
            }
        }
        int commonDenominator = (xn - x0 + 1) * (yn - y0 + 1);
        int mediumApha = (int)(alpha / (double)commonDenominator);
        int mediumRed = (int)(red / (double)commonDenominator);
        int mediumBlue = (int)(blue / (double)commonDenominator);
        int mediumGreen = (int)(green / (double)commonDenominator);
        return this.createColor(mediumApha, mediumRed, mediumGreen, mediumBlue);
    }

    abstract int getBlue(int var1);

    abstract int getGreen(int var1);

    abstract int getRed(int var1);

    abstract int getAlpha(int var1);

    abstract int getImagePixelRGB(int var1, int var2);

    abstract COLOR createColor(int var1, int var2, int var3, int var4);
}

