/*
 * Decompiled with CFR 0.152.
 */
package com.steelzack.chartizate;

import com.steelzack.chartizate.ChartizateFontManager;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public abstract class ChartizateEncodingManager<FONT> {
    protected final Character.UnicodeBlock block;
    protected Set<Character> orderedCharacters = new TreeSet<Character>(this.getComparator());
    protected Character[] characters;
    protected final ChartizateFontManager<FONT> fontManager;
    protected int maximumHeight = 0;

    public ChartizateEncodingManager(Character.UnicodeBlock block, ChartizateFontManager<FONT> fontManager) {
        this.block = block;
        this.fontManager = fontManager;
    }

    abstract int getCharacterFullness(Character var1);

    abstract Character[] getCharacters();

    protected int computeFullness(double fullNess, double total) {
        return (int)(fullNess / total * 1000.0);
    }

    private Comparator<Character> getComparator() {
        return new Comparator<Character>(){

            @Override
            public int compare(Character o1, Character o2) {
                double fullNess2;
                double fullNess1 = ChartizateEncodingManager.this.getCharacterFullness(o1);
                Integer comparisonResult = fullNess1 < (fullNess2 = (double)ChartizateEncodingManager.this.getCharacterFullness(o2)) ? -1 : 0;
                if (comparisonResult == 0) {
                    comparisonResult = o1.compareTo(o2);
                }
                return comparisonResult;
            }
        };
    }

    public void init() {
        for (int codePoint = 0; codePoint <= 0x10FFFF; ++codePoint) {
            if (this.block != Character.UnicodeBlock.of(codePoint)) continue;
            this.orderedCharacters.add(Character.valueOf((char)codePoint));
            int height = this.fontManager.getCharacterHeight((char)codePoint);
            if (height <= this.maximumHeight) continue;
            this.maximumHeight = height;
        }
        this.characters = this.orderedCharacters.toArray(new Character[0]);
    }
}

