/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.spek.extensions;

import ch.tutteli.spek.extensions.TempFolder;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.spek.api.lifecycle.ActionScope;
import org.jetbrains.spek.api.lifecycle.GroupScope;
import org.jetbrains.spek.api.lifecycle.LifecycleListener;
import org.jetbrains.spek.api.lifecycle.TestScope;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 $2\u00020\u0001:\u0002$%B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J/\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00180\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001aJ\u000e\u0010 \u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001aJ\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0003H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006&"}, d2={"Lch/tutteli/spek/extensions/TempFolder;", "Lorg/jetbrains/spek/api/lifecycle/LifecycleListener;", "scope", "Lch/tutteli/spek/extensions/TempFolder$Scope;", "(Lch/tutteli/spek/extensions/TempFolder$Scope;)V", "_tmpDir", "Ljava/nio/file/Path;", "tmpDir", "getTmpDir", "()Ljava/nio/file/Path;", "afterExecuteAction", "", "action", "Lorg/jetbrains/spek/api/lifecycle/ActionScope;", "afterExecuteGroup", "group", "Lorg/jetbrains/spek/api/lifecycle/GroupScope;", "afterExecuteTest", "test", "Lorg/jetbrains/spek/api/lifecycle/TestScope;", "beforeExecuteAction", "beforeExecuteGroup", "beforeExecuteTest", "checkState", "T", "actDescription", "", "act", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "newFile", "name", "newFolder", "setUp", "expectedScope", "tearDown", "Companion", "Scope", "tutteli-spek-extensions"})
public final class TempFolder
implements LifecycleListener {
    private Path _tmpDir;
    private final Scope scope;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Path getTmpDir() {
        return (Path)this.checkState("access tmpDir", tmpDir.1.INSTANCE);
    }

    private final <T> T checkState(String actDescription, Function1<? super Path, ? extends T> act) {
        boolean bl;
        boolean bl2 = bl = this._tmpDir != null;
        if (!bl) {
            String string = "You tried to " + actDescription + " but you cannot use TempFolder outside of a " + this.scope.name() + " scope.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Path path = this._tmpDir;
        if (path == null) {
            Intrinsics.throwNpe();
        }
        return (T)act.invoke((Object)path);
    }

    @NotNull
    public final Path newFile(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object t = this.checkState("call newFile", (Function1)new Function1<Path, Path>(name){
            final /* synthetic */ String $name;

            public final Path invoke(@NotNull Path it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Path path = Files.createFile(it.resolve(this.$name), new FileAttribute[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Files.createFile(it.resolve(name))");
                return path;
            }
            {
                this.$name = string;
                super(1);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"checkState(\"call newFile\u2026eFile(it.resolve(name)) }");
        return (Path)t;
    }

    @NotNull
    public final Path newFolder(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object t = this.checkState("call newFolder", (Function1)new Function1<Path, Path>(name){
            final /* synthetic */ String $name;

            public final Path invoke(@NotNull Path it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Path path = Files.createDirectory(it.resolve(this.$name), new FileAttribute[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Files.createDirectory(it.resolve(name))");
                return path;
            }
            {
                this.$name = string;
                super(1);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"checkState(\"call newFold\u2026ctory(it.resolve(name)) }");
        return (Path)t;
    }

    public void beforeExecuteTest(@NotNull TestScope test) {
        Intrinsics.checkParameterIsNotNull((Object)test, (String)"test");
        this.setUp(Scope.TEST);
    }

    public void beforeExecuteAction(@NotNull ActionScope action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        this.setUp(Scope.ACTION);
    }

    public void beforeExecuteGroup(@NotNull GroupScope group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        this.setUp(Scope.GROUP);
    }

    public void afterExecuteTest(@NotNull TestScope test) {
        Intrinsics.checkParameterIsNotNull((Object)test, (String)"test");
        this.tearDown(Scope.TEST);
    }

    public void afterExecuteAction(@NotNull ActionScope action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        this.tearDown(Scope.ACTION);
    }

    public void afterExecuteGroup(@NotNull GroupScope group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        this.tearDown(Scope.GROUP);
    }

    private final void setUp(Scope expectedScope) {
        if (this.scope == expectedScope) {
            this._tmpDir = Files.createTempDirectory("spek", new FileAttribute[0]);
        }
    }

    private final void tearDown(Scope expectedScope) {
        if (this.scope == expectedScope) {
            Files.walkFileTree(this._tmpDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                    return this.deleteAndContinue(file);
                }

                @NotNull
                public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                    Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                    return this.deleteAndContinue(dir);
                }

                private final FileVisitResult deleteAndContinue(Path path) {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
            });
            this._tmpDir = null;
        }
    }

    private TempFolder(Scope scope) {
        this.scope = scope;
    }

    public /* synthetic */ TempFolder(@NotNull Scope scope, DefaultConstructorMarker $constructor_marker) {
        this(scope);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lch/tutteli/spek/extensions/TempFolder$Scope;", "", "(Ljava/lang/String;I)V", "TEST", "ACTION", "GROUP", "tutteli-spek-extensions"})
    private static final class Scope
    extends Enum<Scope> {
        public static final /* enum */ Scope TEST;
        public static final /* enum */ Scope ACTION;
        public static final /* enum */ Scope GROUP;
        private static final /* synthetic */ Scope[] $VALUES;

        static {
            Scope[] scopeArray = new Scope[3];
            Scope[] scopeArray2 = scopeArray;
            scopeArray[0] = TEST = new Scope();
            scopeArray[1] = ACTION = new Scope();
            scopeArray[2] = GROUP = new Scope();
            $VALUES = scopeArray;
        }

        public static Scope[] values() {
            return (Scope[])$VALUES.clone();
        }

        public static Scope valueOf(String string) {
            return Enum.valueOf(Scope.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lch/tutteli/spek/extensions/TempFolder$Companion;", "", "()V", "perAction", "Lch/tutteli/spek/extensions/TempFolder;", "perGroup", "perTest", "tutteli-spek-extensions"})
    public static final class Companion {
        @NotNull
        public final TempFolder perTest() {
            return new TempFolder(Scope.TEST, null);
        }

        @NotNull
        public final TempFolder perAction() {
            return new TempFolder(Scope.ACTION, null);
        }

        @NotNull
        public final TempFolder perGroup() {
            return new TempFolder(Scope.GROUP, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

