/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.spek.extensions;

import ch.tutteli.spek.extensions.TempFolder;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.spek.api.lifecycle.ActionScope;
import org.jetbrains.spek.api.lifecycle.GroupScope;
import org.jetbrains.spek.api.lifecycle.LifecycleListener;
import org.jetbrains.spek.api.lifecycle.TestScope;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J/\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00120\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0014J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lch/tutteli/spek/extensions/TempFolder;", "Lorg/jetbrains/spek/api/lifecycle/LifecycleListener;", "()V", "_tmpPath", "Ljava/nio/file/Path;", "tmpDir", "Ljava/io/File;", "getTmpDir", "()Ljava/io/File;", "tmpPath", "getTmpPath", "()Ljava/nio/file/Path;", "afterExecuteTest", "", "test", "Lorg/jetbrains/spek/api/lifecycle/TestScope;", "beforeExecuteTest", "checkState", "T", "actDescription", "", "act", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "newFile", "name", "newFolder", "tutteli-spek-extensions"})
public final class TempFolder
implements LifecycleListener {
    private Path _tmpPath;

    @NotNull
    public final File getTmpDir() {
        Object t = this.checkState("access tmpDir", tmpDir.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"checkState(\"access tmpDir\", { it.toFile() })");
        return (File)t;
    }

    @NotNull
    public final Path getTmpPath() {
        return (Path)this.checkState("access tmpPath", tmpPath.1.INSTANCE);
    }

    private final <T> T checkState(String actDescription, Function1<? super Path, ? extends T> act) {
        boolean bl;
        boolean bl2 = bl = this._tmpPath != null;
        if (!bl) {
            String string = "You tried to " + actDescription + " but you cannot use TempFolder outside of a TestScope.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Path path = this._tmpPath;
        if (path == null) {
            Intrinsics.throwNpe();
        }
        return (T)act.invoke((Object)path);
    }

    @NotNull
    public final File newFile(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (File)this.checkState("call newFile", (Function1)new Function1<Path, File>(name){
            final /* synthetic */ String $name;

            @NotNull
            public final File invoke(@NotNull Path it) {
                File file;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                File $receiver = file = new File(it.toFile(), this.$name);
                $receiver.createNewFile();
                return file;
            }
            {
                this.$name = string;
                super(1);
            }
        });
    }

    @NotNull
    public final File newFolder(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (File)this.checkState("call newFolder", (Function1)new Function1<Path, File>(name){
            final /* synthetic */ String $name;

            @NotNull
            public final File invoke(@NotNull Path it) {
                File file;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                File $receiver = file = new File(it.toFile(), this.$name);
                $receiver.mkdir();
                return file;
            }
            {
                this.$name = string;
                super(1);
            }
        });
    }

    public void beforeExecuteTest(@NotNull TestScope test) {
        Intrinsics.checkParameterIsNotNull((Object)test, (String)"test");
        this._tmpPath = Files.createTempDirectory("spek", new FileAttribute[0]);
    }

    public void afterExecuteTest(@NotNull TestScope test) {
        Intrinsics.checkParameterIsNotNull((Object)test, (String)"test");
        Files.walkFileTree(this._tmpPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                return this.deleteAndContinue(file);
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                return this.deleteAndContinue(dir);
            }

            private final FileVisitResult deleteAndContinue(Path path) {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
        this._tmpPath = null;
    }

    public void afterExecuteAction(@NotNull ActionScope action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        LifecycleListener.DefaultImpls.afterExecuteAction((LifecycleListener)this, (ActionScope)action);
    }

    public void afterExecuteGroup(@NotNull GroupScope group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        LifecycleListener.DefaultImpls.afterExecuteGroup((LifecycleListener)this, (GroupScope)group);
    }

    public void beforeExecuteAction(@NotNull ActionScope action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        LifecycleListener.DefaultImpls.beforeExecuteAction((LifecycleListener)this, (ActionScope)action);
    }

    public void beforeExecuteGroup(@NotNull GroupScope group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        LifecycleListener.DefaultImpls.beforeExecuteGroup((LifecycleListener)this, (GroupScope)group);
    }
}

