/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.reporting.translating;

import ch.tutteli.atrium.reporting.translating.LocaleOrderDecider;
import ch.tutteli.atrium.reporting.translating.Translatable;
import ch.tutteli.atrium.reporting.translating.TranslationSupplier;
import java.io.Closeable;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J=\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00072\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0014H\u0004\u00a2\u0006\u0002\u0010\u0015R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0088\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lch/tutteli/atrium/reporting/translating/PropertiesBasedTranslationSupplier;", "T", "Lch/tutteli/atrium/reporting/translating/TranslationSupplier;", "()V", "translations", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "get", "translatable", "Lch/tutteli/atrium/reporting/translating/Translatable;", "locale", "Ljava/util/Locale;", "getFileNameFor", "baseName", "getNotForRoot", "getOrLoadProperties", "key", "fileName", "keyCreator", "Lkotlin/Function1;", "(Ljava/lang/Object;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/util/Map;", "atrium-core-impl-robstoll-lib"})
public abstract class PropertiesBasedTranslationSupplier<T>
implements TranslationSupplier {
    private final ConcurrentHashMap<T, Map<String, String>> translations = new ConcurrentHashMap();

    @Nullable
    public final String get(@NotNull Translatable translatable, @NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)translatable, (String)"translatable");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        boolean bl = Intrinsics.areEqual((Object)locale, (Object)Locale.ROOT) ^ true;
        if (!bl) {
            String string = "Locale.ROOT is not supported -- most likely a bug in the chosen implementation of " + Reflection.getOrCreateKotlinClass(LocaleOrderDecider.class).getSimpleName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.getNotForRoot(translatable, locale);
    }

    @Nullable
    protected abstract String getNotForRoot(@NotNull Translatable var1, @NotNull Locale var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<String, String> getOrLoadProperties(T key, @NotNull String fileName, @NotNull Function1<? super String, String> keyCreator) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull(keyCreator, (String)"keyCreator");
        boolean bl2 = bl = !StringsKt.contains$default((CharSequence)fileName, (CharSequence)"../", (boolean)false, (int)2, null);
        if (!bl) {
            String string = "only absolute paths without any '../' are allowed";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ConcurrentMap $receiver$iv = this.translations;
        Object object = $receiver$iv.get(key);
        if (object == null) {
            Map map;
            Map default$iv;
            Map map2;
            String absoluteFileName = StringsKt.startsWith$default((CharSequence)fileName, (char)'/', (boolean)false, (int)2, null) ? fileName : '/' + fileName;
            InputStream file = this.getClass().getResourceAsStream("" + absoluteFileName + ".properties");
            if (file != null) {
                void $receiver$iv$iv;
                Object it2;
                Properties properties = new Properties();
                Closeable closeable = file;
                Throwable throwable = null;
                try {
                    it2 = (InputStream)closeable;
                    properties.load((InputStream)it2);
                    it2 = Unit.INSTANCE;
                }
                catch (Throwable it2) {
                    throwable = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Set<String> set = properties.stringPropertyNames();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"properties.stringPropertyNames()");
                Iterable $receiver$iv2 = set;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
                it2 = $receiver$iv2;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                for (Object element$iv$iv : $receiver$iv$iv) {
                    String it3;
                    Map map3 = destination$iv$iv;
                    String string = it3 = (String)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    Pair pair = TuplesKt.to((Object)keyCreator.invoke((Object)string), (Object)properties.getProperty(it3));
                    map3.put(pair.getFirst(), pair.getSecond());
                }
                map2 = destination$iv$iv;
            } else {
                map2 = MapsKt.emptyMap();
            }
            if ((object = $receiver$iv.putIfAbsent(key, default$iv = (map = map2))) == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"this.translations.getOrP\u2026\n            }\n        })");
        return (Map)object;
    }

    @NotNull
    protected final String getFileNameFor(@NotNull String baseName, @NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)baseName, (String)"baseName");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        StringBuilder sb = new StringBuilder(baseName).append('_').append(locale.getLanguage());
        String string = locale.getScript();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locale.script");
        CharSequence charSequence = string;
        if (charSequence.length() > 0) {
            sb.append('_').append(locale.getScript());
        }
        String string2 = locale.getCountry();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"locale.country");
        charSequence = string2;
        if (charSequence.length() > 0) {
            sb.append('_').append(locale.getCountry());
        }
        String string3 = locale.getVariant();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"locale.variant");
        charSequence = string3;
        if (charSequence.length() > 0) {
            sb.append('_').append(locale.getVariant());
        }
        String string4 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sb.toString()");
        return StringsKt.replace$default((String)string4, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }
}

