/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.reporting.translating;

import ch.tutteli.atrium.reporting.translating.ArgumentsSupportingTranslator;
import ch.tutteli.atrium.reporting.translating.ITranslatable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lch/tutteli/atrium/reporting/translating/ResourceBundleBasedTranslator;", "Lch/tutteli/atrium/reporting/translating/ArgumentsSupportingTranslator;", "primaryLocale", "Ljava/util/Locale;", "resourceBundleControl", "Ljava/util/ResourceBundle$Control;", "(Ljava/util/Locale;Ljava/util/ResourceBundle$Control;)V", "translateWithoutArgs", "", "translatable", "Lch/tutteli/atrium/reporting/translating/ITranslatable;", "Companion", "FallbackResourceBundleControl", "atrium-core-impl-robstoll-lib"})
public final class ResourceBundleBasedTranslator
extends ArgumentsSupportingTranslator {
    private final ResourceBundle.Control resourceBundleControl;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected String translateWithoutArgs(@NotNull ITranslatable translatable) {
        Intrinsics.checkParameterIsNotNull((Object)translatable, (String)"translatable");
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(translatable.getClass().getName(), this.getPrimaryLocale(), this.resourceBundleControl);
            String string = bundle.getString(translatable.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bundle.getString(translatable.name)");
            return string;
        }
        catch (MissingResourceException ex) {
            return translatable.getDefault();
        }
    }

    private ResourceBundleBasedTranslator(Locale primaryLocale, ResourceBundle.Control resourceBundleControl) {
        super(primaryLocale);
        this.resourceBundleControl = resourceBundleControl;
    }

    public /* synthetic */ ResourceBundleBasedTranslator(@NotNull Locale primaryLocale, @NotNull ResourceBundle.Control resourceBundleControl, DefaultConstructorMarker $constructor_marker) {
        this(primaryLocale, resourceBundleControl);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lch/tutteli/atrium/reporting/translating/ResourceBundleBasedTranslator$FallbackResourceBundleControl;", "Ljava/util/ResourceBundle$Control;", "fallbackLocales", "", "Ljava/util/Locale;", "(Ljava/util/List;)V", "getFallbackLocale", "baseName", "", "locale", "getFormats", "atrium-core-impl-robstoll-lib"})
    private static final class FallbackResourceBundleControl
    extends ResourceBundle.Control {
        private final List<Locale> fallbackLocales;

        @Override
        @NotNull
        public List<String> getFormats(@Nullable String baseName) {
            List<String> list = ResourceBundle.Control.FORMAT_PROPERTIES;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"ResourceBundle.Control.FORMAT_PROPERTIES");
            return list;
        }

        @Override
        @Nullable
        public Locale getFallbackLocale(@Nullable String baseName, @Nullable Locale locale) {
            int index;
            if (locale != null && (index = this.fallbackLocales.indexOf(locale)) != -1 && index + 1 < this.fallbackLocales.size()) {
                return this.fallbackLocales.get(index + 1);
            }
            return null;
        }

        public FallbackResourceBundleControl(@NotNull List<Locale> fallbackLocales) {
            Intrinsics.checkParameterIsNotNull(fallbackLocales, (String)"fallbackLocales");
            this.fallbackLocales = fallbackLocales;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b\"\u00020\u0006\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lch/tutteli/atrium/reporting/translating/ResourceBundleBasedTranslator$Companion;", "", "()V", "create", "Lch/tutteli/atrium/reporting/translating/ResourceBundleBasedTranslator;", "primaryLocale", "Ljava/util/Locale;", "fallbackLocales", "", "(Ljava/util/Locale;[Ljava/util/Locale;)Lch/tutteli/atrium/reporting/translating/ResourceBundleBasedTranslator;", "atrium-core-impl-robstoll-lib"})
    public static final class Companion {
        @NotNull
        public final ResourceBundleBasedTranslator create(@NotNull Locale primaryLocale, Locale ... fallbackLocales) {
            ResourceBundle.Control control;
            ResourceBundle.Control control2;
            Intrinsics.checkParameterIsNotNull((Object)primaryLocale, (String)"primaryLocale");
            Intrinsics.checkParameterIsNotNull((Object)fallbackLocales, (String)"fallbackLocales");
            Object[] objectArray = fallbackLocales;
            if (objectArray.length == 0) {
                control2 = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES);
            } else {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)primaryLocale);
                spreadBuilder.addSpread((Object)fallbackLocales);
                control2 = new FallbackResourceBundleControl(CollectionsKt.listOf((Object[])((Locale[])spreadBuilder.toArray((Object[])new Locale[spreadBuilder.size()]))));
            }
            ResourceBundle.Control control3 = control = control2;
            Intrinsics.checkExpressionValueIsNotNull((Object)control3, (String)"control");
            return new ResourceBundleBasedTranslator(primaryLocale, control3, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

