/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.reporting;

import ch.tutteli.atrium.assertions.IAssertion;
import ch.tutteli.atrium.assertions.IAssertionGroup;
import ch.tutteli.atrium.assertions.IAssertionGroupType;
import ch.tutteli.atrium.assertions.IBasicAssertion;
import ch.tutteli.atrium.assertions.IBulletPointIdentifier;
import ch.tutteli.atrium.assertions.IExplanatoryAssertion;
import ch.tutteli.atrium.assertions.RootAssertionGroupType;
import ch.tutteli.atrium.reporting.AssertionFormatterMethodObject;
import ch.tutteli.atrium.reporting.IAssertionFormatter;
import ch.tutteli.atrium.reporting.IAssertionFormatterController;
import ch.tutteli.atrium.reporting.IAssertionPairFormatter;
import ch.tutteli.atrium.reporting.IObjectFormatter;
import ch.tutteli.atrium.reporting.TextPrefixBasedAssertionGroupFormatter;
import ch.tutteli.atrium.reporting.translating.ITranslatable;
import ch.tutteli.atrium.reporting.translating.Untranslatable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\u0012\u001a\u0010\u0002\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J>\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152$\u0010 \u001a \u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00110\"\u0012\u0004\u0012\u00020\u00110!H\u0016J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010$\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lch/tutteli/atrium/reporting/TextFallbackAssertionFormatter;", "Lch/tutteli/atrium/reporting/IAssertionFormatter;", "bulletPoints", "", "Ljava/lang/Class;", "Lch/tutteli/atrium/assertions/IBulletPointIdentifier;", "", "assertionFormatterController", "Lch/tutteli/atrium/reporting/IAssertionFormatterController;", "assertionPairFormatter", "Lch/tutteli/atrium/reporting/IAssertionPairFormatter;", "objectFormatter", "Lch/tutteli/atrium/reporting/IObjectFormatter;", "(Ljava/util/Map;Lch/tutteli/atrium/reporting/IAssertionFormatterController;Lch/tutteli/atrium/reporting/IAssertionPairFormatter;Lch/tutteli/atrium/reporting/IObjectFormatter;)V", "formatter", "Lch/tutteli/atrium/reporting/TextPrefixBasedAssertionGroupFormatter;", "appendBasicAssertion", "", "basicAssertion", "Lch/tutteli/atrium/assertions/IBasicAssertion;", "methodObject", "Lch/tutteli/atrium/reporting/AssertionFormatterMethodObject;", "appendExplanatoryAssertion", "assertion", "Lch/tutteli/atrium/assertions/IExplanatoryAssertion;", "canFormat", "", "Lch/tutteli/atrium/assertions/IAssertion;", "formatFallback", "formatGroup", "assertionGroup", "Lch/tutteli/atrium/assertions/IAssertionGroup;", "formatAssertions", "Lkotlin/Function2;", "Lkotlin/Function1;", "formatGroupHeaderAndGetChildMethodObject", "formatNonGroup", "atrium-core-impl-robstoll-lib"})
public final class TextFallbackAssertionFormatter
implements IAssertionFormatter {
    private final TextPrefixBasedAssertionGroupFormatter formatter;
    private final IAssertionFormatterController assertionFormatterController;
    private final IAssertionPairFormatter assertionPairFormatter;
    private final IObjectFormatter objectFormatter;

    public boolean canFormat(@NotNull IAssertion assertion) {
        Intrinsics.checkParameterIsNotNull((Object)assertion, (String)"assertion");
        return true;
    }

    public void formatNonGroup(@NotNull IAssertion assertion, @NotNull AssertionFormatterMethodObject methodObject) {
        Intrinsics.checkParameterIsNotNull((Object)assertion, (String)"assertion");
        Intrinsics.checkParameterIsNotNull((Object)methodObject, (String)"methodObject");
        methodObject.appendLnIndentAndPrefix();
        IAssertion iAssertion = assertion;
        if (iAssertion instanceof IBasicAssertion) {
            this.appendBasicAssertion((IBasicAssertion)assertion, methodObject);
        } else if (iAssertion instanceof IExplanatoryAssertion) {
            this.appendExplanatoryAssertion((IExplanatoryAssertion)assertion, methodObject);
        } else {
            this.formatFallback(assertion, methodObject);
        }
    }

    private final void appendBasicAssertion(IBasicAssertion basicAssertion, AssertionFormatterMethodObject methodObject) {
        this.assertionPairFormatter.format(methodObject, basicAssertion.getDescription(), basicAssertion.getExpected());
    }

    private final void appendExplanatoryAssertion(IExplanatoryAssertion assertion, AssertionFormatterMethodObject methodObject) {
        methodObject.getSb().append(this.objectFormatter.format(assertion.getExplanation()));
    }

    private final void formatFallback(IAssertion assertion, AssertionFormatterMethodObject methodObject) {
        Untranslatable translatable = new Untranslatable((CharSequence)("Unsupported type " + assertion.getClass().getName() + ", can only report whether it holds"));
        this.assertionPairFormatter.format(methodObject, (ITranslatable)translatable, (Object)assertion.holds());
    }

    public void formatGroup(@NotNull IAssertionGroup assertionGroup, @NotNull AssertionFormatterMethodObject methodObject, @NotNull Function2<? super AssertionFormatterMethodObject, ? super Function1<? super IAssertion, Unit>, Unit> formatAssertions) {
        Intrinsics.checkParameterIsNotNull((Object)assertionGroup, (String)"assertionGroup");
        Intrinsics.checkParameterIsNotNull((Object)methodObject, (String)"methodObject");
        Intrinsics.checkParameterIsNotNull(formatAssertions, (String)"formatAssertions");
        AssertionFormatterMethodObject childMethodObject = this.formatGroupHeaderAndGetChildMethodObject(assertionGroup, methodObject);
        formatAssertions.invoke((Object)childMethodObject, (Object)new Function1<IAssertion, Unit>(this, childMethodObject){
            final /* synthetic */ TextFallbackAssertionFormatter this$0;
            final /* synthetic */ AssertionFormatterMethodObject $childMethodObject;

            public final void invoke(@NotNull IAssertion it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                TextFallbackAssertionFormatter.access$getAssertionFormatterController$p(this.this$0).format(it, this.$childMethodObject);
            }
            {
                this.this$0 = textFallbackAssertionFormatter;
                this.$childMethodObject = assertionFormatterMethodObject;
                super(1);
            }
        });
    }

    private final AssertionFormatterMethodObject formatGroupHeaderAndGetChildMethodObject(IAssertionGroup assertionGroup, AssertionFormatterMethodObject methodObject) {
        IAssertionGroupType iAssertionGroupType = assertionGroup.getType();
        return iAssertionGroupType instanceof RootAssertionGroupType ? this.formatter.formatAfterAppendLnEtc(this.assertionPairFormatter, assertionGroup, methodObject) : this.formatter.formatWithGroupName(this.assertionPairFormatter, assertionGroup, methodObject);
    }

    public TextFallbackAssertionFormatter(@NotNull Map<Class<? extends IBulletPointIdentifier>, String> bulletPoints, @NotNull IAssertionFormatterController assertionFormatterController, @NotNull IAssertionPairFormatter assertionPairFormatter, @NotNull IObjectFormatter objectFormatter) {
        Intrinsics.checkParameterIsNotNull(bulletPoints, (String)"bulletPoints");
        Intrinsics.checkParameterIsNotNull((Object)assertionFormatterController, (String)"assertionFormatterController");
        Intrinsics.checkParameterIsNotNull((Object)assertionPairFormatter, (String)"assertionPairFormatter");
        Intrinsics.checkParameterIsNotNull((Object)objectFormatter, (String)"objectFormatter");
        this.assertionFormatterController = assertionFormatterController;
        this.assertionPairFormatter = assertionPairFormatter;
        this.objectFormatter = objectFormatter;
        String string = bulletPoints.get(RootAssertionGroupType.class);
        if (string == null) {
            string = "\u25c6\u2004";
        }
        this.formatter = new TextPrefixBasedAssertionGroupFormatter(string);
    }

    public void format(@NotNull IAssertion assertion, @NotNull AssertionFormatterMethodObject methodObject) {
        Intrinsics.checkParameterIsNotNull((Object)assertion, (String)"assertion");
        Intrinsics.checkParameterIsNotNull((Object)methodObject, (String)"methodObject");
        IAssertionFormatter.DefaultImpls.format((IAssertionFormatter)this, (IAssertion)assertion, (AssertionFormatterMethodObject)methodObject);
    }

    @NotNull
    public static final /* synthetic */ IAssertionFormatterController access$getAssertionFormatterController$p(TextFallbackAssertionFormatter $this) {
        return $this.assertionFormatterController;
    }
}

