package ch.tutteli.atrium.creating

class CheckingAssertionPlant<out T : Any>(
    override val subject: T
) : BaseAssertionPlant<T, IAssertionPlant<T>>(), ICheckingAssertionPlant<T> {
    override val self = this

    override fun addAssertionsCreatedBy(assertionCreator: IAssertionPlant<T>.() -> Unit): IAssertionPlant<T> {
        this.assertionCreator()
        return this
    }

    override fun allAssertionsHold(): Boolean {
        val assertions = getAssertions()
        check(!assertions.isEmpty()) { "You need to create assertions first before checking whether they all hold." }

        try {
            return assertions.all { it.holds() }
        } finally {
            clearAssertions()
        }
    }

}

