/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.reporting.translating;

import ch.tutteli.atrium.reporting.translating.Translatable;
import ch.tutteli.atrium.reporting.translating.TranslatableWithArgs;
import ch.tutteli.atrium.reporting.translating.Translator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH$R\u001e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lch/tutteli/atrium/reporting/translating/ArgumentsSupportingTranslator;", "Lch/tutteli/atrium/reporting/translating/Translator;", "primaryLocale", "Ljava/util/Locale;", "fallbackLocales", "", "(Ljava/util/Locale;[Ljava/util/Locale;)V", "getFallbackLocales", "()[Ljava/util/Locale;", "[Ljava/util/Locale;", "getPrimaryLocale", "()Ljava/util/Locale;", "translate", "", "translatable", "Lch/tutteli/atrium/reporting/translating/Translatable;", "translateWithArgs", "translatableWithArgs", "Lch/tutteli/atrium/reporting/translating/TranslatableWithArgs;", "translateWithoutArgs", "atrium-core-api"})
public abstract class ArgumentsSupportingTranslator
implements Translator {
    @NotNull
    private final Locale primaryLocale;
    @NotNull
    private final Locale[] fallbackLocales;

    @Override
    @NotNull
    public final String translate(@NotNull Translatable translatable) {
        Intrinsics.checkParameterIsNotNull((Object)translatable, (String)"translatable");
        Translatable translatable2 = translatable;
        return translatable2 instanceof TranslatableWithArgs ? this.translateWithArgs((TranslatableWithArgs)translatable) : this.translateWithoutArgs(translatable);
    }

    @NotNull
    protected abstract String translateWithoutArgs(@NotNull Translatable var1);

    /*
     * WARNING - void declaration
     */
    private final String translateWithArgs(TranslatableWithArgs translatableWithArgs) {
        String result = this.translateWithoutArgs(translatableWithArgs.getTranslatable());
        int size$iv = translatableWithArgs.getArguments().length;
        Object[] result$iv = new Object[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            Object object;
            void index;
            void i$iv;
            void var8_9 = i$iv;
            void var14_13 = i$iv;
            Object[] objectArray = result$iv;
            Object arg = translatableWithArgs.getArguments()[index];
            Object object2 = arg;
            objectArray[var14_13] = object = object2 instanceof Translatable ? this.translate((Translatable)arg) : arg;
            ++i$iv;
        }
        Object[] arr = result$iv;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = this.primaryLocale;
        Object[] objectArray = Arrays.copyOf(arr, arr.length);
        String string = String.format(locale, result, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(locale, format, *args)");
        return string;
    }

    @NotNull
    protected final Locale getPrimaryLocale() {
        return this.primaryLocale;
    }

    @NotNull
    protected final Locale[] getFallbackLocales() {
        return this.fallbackLocales;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArgumentsSupportingTranslator(@NotNull Locale primaryLocale, @NotNull Locale[] fallbackLocales) {
        Locale it;
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)primaryLocale, (String)"primaryLocale");
        Intrinsics.checkParameterIsNotNull((Object)fallbackLocales, (String)"fallbackLocales");
        this.primaryLocale = primaryLocale;
        this.fallbackLocales = fallbackLocales;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)this.primaryLocale);
        spreadBuilder.addSpread((Object)this.fallbackLocales);
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])((Locale[])spreadBuilder.toArray((Object[])new Locale[spreadBuilder.size()])));
        Iterator iterator = $receiver$iv.iterator();
        do {
            block7: {
                block6: {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    Object element$iv = iterator.next();
                    it = (Locale)element$iv;
                    bl2 = Intrinsics.areEqual((Object)it.getLanguage(), (Object)"no") ^ true;
                    if (!bl2) {
                        String string = "The macrolanguage `no` is not supported but " + it + " given.\nUse either nb_... or nn_...";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    if (Intrinsics.areEqual((Object)it.getLanguage(), (Object)"zh") ^ true) break block6;
                    String string = it.getCountry();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.country");
                    CharSequence charSequence = string;
                    if (!(charSequence.length() > 0) && (!(Intrinsics.areEqual((Object)it.getScript(), (Object)"Hans") ^ true) || !(Intrinsics.areEqual((Object)it.getScript(), (Object)"Hant") ^ true))) break block7;
                }
                bl = true;
                continue;
            }
            bl = false;
        } while (bl2 = bl);
        String countries = Intrinsics.areEqual((Object)it.getScript(), (Object)"Hant") ? "TW, HK or MO" : "CN or SG";
        String string = "Script `" + it.getScript() + "` for Locale with language `zh` is not supported.\nUse a corresponding country instead (" + countries + ").";
        throw (Throwable)new IllegalArgumentException(string.toString());
    }
}

