/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.reporting;

import ch.tutteli.atrium.AtriumFactory;
import ch.tutteli.atrium.assertions.IBulletPointIdentifier;
import ch.tutteli.atrium.reporting.IAssertionFormatter;
import ch.tutteli.atrium.reporting.IAssertionFormatterController;
import ch.tutteli.atrium.reporting.IAssertionFormatterFacade;
import ch.tutteli.atrium.reporting.IObjectFormatter;
import ch.tutteli.atrium.reporting.IReporter;
import ch.tutteli.atrium.reporting.translating.ITranslationSupplier;
import ch.tutteli.atrium.reporting.translating.ITranslator;
import ch.tutteli.atrium.reporting.translating.UsingDefaultTranslator;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0005\n\u000b\f\r\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\bJ\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lch/tutteli/atrium/reporting/ReporterBuilder;", "", "assertionFormatterFacade", "Lch/tutteli/atrium/reporting/IAssertionFormatterFacade;", "(Lch/tutteli/atrium/reporting/IAssertionFormatterFacade;)V", "buildCustomReporter", "Lch/tutteli/atrium/reporting/IReporter;", "factory", "Lkotlin/Function1;", "buildOnlyFailureReporter", "AssertionFormatterControllerOptions", "AssertionFormatterFacadeOptions", "AssertionFormatterOptions", "Companion", "ObjectFormatterOptions", "atrium-assertions"})
public final class ReporterBuilder {
    private final IAssertionFormatterFacade assertionFormatterFacade;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final IReporter buildOnlyFailureReporter() {
        return AtriumFactory.INSTANCE.newOnlyFailureReporter(this.assertionFormatterFacade);
    }

    @NotNull
    public final IReporter buildCustomReporter(@NotNull Function1<? super IAssertionFormatterFacade, ? extends IReporter> factory) {
        Intrinsics.checkParameterIsNotNull(factory, (String)"factory");
        return (IReporter)factory.invoke((Object)this.assertionFormatterFacade);
    }

    public ReporterBuilder(@NotNull IAssertionFormatterFacade assertionFormatterFacade) {
        Intrinsics.checkParameterIsNotNull((Object)assertionFormatterFacade, (String)"assertionFormatterFacade");
        this.assertionFormatterFacade = assertionFormatterFacade;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lch/tutteli/atrium/reporting/ReporterBuilder$ObjectFormatterOptions;", "", "translator", "Lch/tutteli/atrium/reporting/translating/ITranslator;", "(Lch/tutteli/atrium/reporting/translating/ITranslator;)V", "withDetailedObjectFormatter", "Lch/tutteli/atrium/reporting/ReporterBuilder$AssertionFormatterControllerOptions;", "withObjectFormatter", "objectFormatter", "Lch/tutteli/atrium/reporting/IObjectFormatter;", "atrium-assertions"})
    public static final class ObjectFormatterOptions {
        private final ITranslator translator;

        @NotNull
        public final AssertionFormatterControllerOptions withDetailedObjectFormatter() {
            return new AssertionFormatterControllerOptions(AtriumFactory.INSTANCE.newDetailedObjectFormatter(this.translator), this.translator);
        }

        @NotNull
        public final AssertionFormatterControllerOptions withObjectFormatter(@NotNull IObjectFormatter objectFormatter) {
            Intrinsics.checkParameterIsNotNull((Object)objectFormatter, (String)"objectFormatter");
            return new AssertionFormatterControllerOptions(objectFormatter, this.translator);
        }

        public ObjectFormatterOptions(@NotNull ITranslator translator) {
            Intrinsics.checkParameterIsNotNull((Object)translator, (String)"translator");
            this.translator = translator;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lch/tutteli/atrium/reporting/ReporterBuilder$AssertionFormatterControllerOptions;", "", "objectFormatter", "Lch/tutteli/atrium/reporting/IObjectFormatter;", "translator", "Lch/tutteli/atrium/reporting/translating/ITranslator;", "(Lch/tutteli/atrium/reporting/IObjectFormatter;Lch/tutteli/atrium/reporting/translating/ITranslator;)V", "withDefaultAssertionFormatterController", "Lch/tutteli/atrium/reporting/ReporterBuilder$AssertionFormatterFacadeOptions;", "atrium-assertions"})
    public static final class AssertionFormatterControllerOptions {
        private final IObjectFormatter objectFormatter;
        private final ITranslator translator;

        @NotNull
        public final AssertionFormatterFacadeOptions withDefaultAssertionFormatterController() {
            return new AssertionFormatterFacadeOptions(AtriumFactory.INSTANCE.newAssertionFormatterController(), this.objectFormatter, this.translator);
        }

        public AssertionFormatterControllerOptions(@NotNull IObjectFormatter objectFormatter, @NotNull ITranslator translator) {
            Intrinsics.checkParameterIsNotNull((Object)objectFormatter, (String)"objectFormatter");
            Intrinsics.checkParameterIsNotNull((Object)translator, (String)"translator");
            this.objectFormatter = objectFormatter;
            this.translator = translator;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lch/tutteli/atrium/reporting/ReporterBuilder$AssertionFormatterFacadeOptions;", "", "assertionFormatterController", "Lch/tutteli/atrium/reporting/IAssertionFormatterController;", "objectFormatter", "Lch/tutteli/atrium/reporting/IObjectFormatter;", "translator", "Lch/tutteli/atrium/reporting/translating/ITranslator;", "(Lch/tutteli/atrium/reporting/IAssertionFormatterController;Lch/tutteli/atrium/reporting/IObjectFormatter;Lch/tutteli/atrium/reporting/translating/ITranslator;)V", "withDefaultAssertionFormatterFacade", "Lch/tutteli/atrium/reporting/ReporterBuilder$AssertionFormatterOptions;", "atrium-assertions"})
    public static final class AssertionFormatterFacadeOptions {
        private final IAssertionFormatterController assertionFormatterController;
        private final IObjectFormatter objectFormatter;
        private final ITranslator translator;

        @NotNull
        public final AssertionFormatterOptions withDefaultAssertionFormatterFacade() {
            return new AssertionFormatterOptions(AtriumFactory.INSTANCE.newAssertionFormatterFacade(this.assertionFormatterController), this.objectFormatter, this.translator);
        }

        public AssertionFormatterFacadeOptions(@NotNull IAssertionFormatterController assertionFormatterController, @NotNull IObjectFormatter objectFormatter, @NotNull ITranslator translator) {
            Intrinsics.checkParameterIsNotNull((Object)assertionFormatterController, (String)"assertionFormatterController");
            Intrinsics.checkParameterIsNotNull((Object)objectFormatter, (String)"objectFormatter");
            Intrinsics.checkParameterIsNotNull((Object)translator, (String)"translator");
            this.assertionFormatterController = assertionFormatterController;
            this.objectFormatter = objectFormatter;
            this.translator = translator;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fJ\b\u0010\u000f\u001a\u00020\nH\u0007JG\u0010\u0010\u001a\u00020\n2:\u0010\u0011\u001a\u001e\u0012\u001a\b\u0001\u0012\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\u0012\u0004\u0012\u00020\u00160\u00130\u0012\"\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\u0012\u0004\u0012\u00020\u00160\u0013\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lch/tutteli/atrium/reporting/ReporterBuilder$AssertionFormatterOptions;", "", "assertionFormatterFacade", "Lch/tutteli/atrium/reporting/IAssertionFormatterFacade;", "objectFormatter", "Lch/tutteli/atrium/reporting/IObjectFormatter;", "translator", "Lch/tutteli/atrium/reporting/translating/ITranslator;", "(Lch/tutteli/atrium/reporting/IAssertionFormatterFacade;Lch/tutteli/atrium/reporting/IObjectFormatter;Lch/tutteli/atrium/reporting/translating/ITranslator;)V", "withAssertionFormatter", "Lch/tutteli/atrium/reporting/ReporterBuilder;", "assertionFormatterFactory", "Lkotlin/Function1;", "Lch/tutteli/atrium/reporting/IAssertionFormatterController;", "Lch/tutteli/atrium/reporting/IAssertionFormatter;", "withSameLineAssertionFormatter", "withSameLineTextAssertionFormatter", "bulletPoints", "", "Lkotlin/Pair;", "Ljava/lang/Class;", "Lch/tutteli/atrium/assertions/IBulletPointIdentifier;", "", "([Lkotlin/Pair;)Lch/tutteli/atrium/reporting/ReporterBuilder;", "atrium-assertions"})
    public static final class AssertionFormatterOptions {
        private final IAssertionFormatterFacade assertionFormatterFacade;
        private final IObjectFormatter objectFormatter;
        private final ITranslator translator;

        @NotNull
        public final ReporterBuilder withSameLineTextAssertionFormatter(Pair<? extends Class<? extends IBulletPointIdentifier>, String> ... bulletPoints) {
            Intrinsics.checkParameterIsNotNull(bulletPoints, (String)"bulletPoints");
            AtriumFactory.INSTANCE.registerSameLineTextAssertionFormatterCapabilities(MapsKt.toMap(bulletPoints), this.assertionFormatterFacade, this.objectFormatter, this.translator);
            return new ReporterBuilder(this.assertionFormatterFacade);
        }

        @Deprecated(message="Use withSameLineTextAssertionFormatter instead", replaceWith=@ReplaceWith(imports={}, expression="withSameLineTextAssertionFormatter()"))
        @NotNull
        public final ReporterBuilder withSameLineAssertionFormatter() {
            return this.withSameLineTextAssertionFormatter(new Pair[0]);
        }

        @NotNull
        public final ReporterBuilder withAssertionFormatter(@NotNull Function1<? super IAssertionFormatterController, ? extends IAssertionFormatter> assertionFormatterFactory) {
            Intrinsics.checkParameterIsNotNull(assertionFormatterFactory, (String)"assertionFormatterFactory");
            this.assertionFormatterFacade.register(assertionFormatterFactory);
            return new ReporterBuilder(this.assertionFormatterFacade);
        }

        public AssertionFormatterOptions(@NotNull IAssertionFormatterFacade assertionFormatterFacade, @NotNull IObjectFormatter objectFormatter, @NotNull ITranslator translator) {
            Intrinsics.checkParameterIsNotNull((Object)assertionFormatterFacade, (String)"assertionFormatterFacade");
            Intrinsics.checkParameterIsNotNull((Object)objectFormatter, (String)"objectFormatter");
            Intrinsics.checkParameterIsNotNull((Object)translator, (String)"translator");
            this.assertionFormatterFacade = assertionFormatterFacade;
            this.objectFormatter = objectFormatter;
            this.translator = translator;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J/\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\f\"\u00020\n\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\n\u00a8\u0006\u0013"}, d2={"Lch/tutteli/atrium/reporting/ReporterBuilder$Companion;", "", "()V", "withDetailedObjectFormatter", "Lch/tutteli/atrium/reporting/ReporterBuilder$AssertionFormatterOptions;", "withTranslations", "Lch/tutteli/atrium/reporting/ReporterBuilder$ObjectFormatterOptions;", "translationSupplier", "Lch/tutteli/atrium/reporting/translating/ITranslationSupplier;", "locale", "Ljava/util/Locale;", "fallbackLocales", "", "(Lch/tutteli/atrium/reporting/translating/ITranslationSupplier;Ljava/util/Locale;[Ljava/util/Locale;)Lch/tutteli/atrium/reporting/ReporterBuilder$ObjectFormatterOptions;", "withTranslator", "translator", "Lch/tutteli/atrium/reporting/translating/ITranslator;", "withoutTranslations", "primaryLocale", "atrium-assertions"})
    public static final class Companion {
        @NotNull
        public final ObjectFormatterOptions withoutTranslations(@NotNull Locale primaryLocale) {
            Intrinsics.checkParameterIsNotNull((Object)primaryLocale, (String)"primaryLocale");
            return new ObjectFormatterOptions((ITranslator)new UsingDefaultTranslator(primaryLocale));
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ObjectFormatterOptions withoutTranslations$default(Companion companion, Locale locale, int n, Object object) {
            if ((n & 1) != 0) {
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.getDefault()");
                locale = locale2;
            }
            return companion.withoutTranslations(locale);
        }

        @NotNull
        public final ObjectFormatterOptions withTranslations(@NotNull ITranslationSupplier translationSupplier, @NotNull Locale locale, Locale ... fallbackLocales) {
            Intrinsics.checkParameterIsNotNull((Object)translationSupplier, (String)"translationSupplier");
            Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
            Intrinsics.checkParameterIsNotNull((Object)fallbackLocales, (String)"fallbackLocales");
            return new ObjectFormatterOptions(AtriumFactory.INSTANCE.newTranslator(translationSupplier, locale, Arrays.copyOf(fallbackLocales, fallbackLocales.length)));
        }

        @NotNull
        public final ObjectFormatterOptions withTranslator(@NotNull ITranslator translator) {
            Intrinsics.checkParameterIsNotNull((Object)translator, (String)"translator");
            return new ObjectFormatterOptions(translator);
        }

        @NotNull
        public final AssertionFormatterOptions withDetailedObjectFormatter() {
            return ch.tutteli.atrium.reporting.ReporterBuilder$Companion.withoutTranslations$default(this, null, 1, null).withDetailedObjectFormatter().withDefaultAssertionFormatterController().withDefaultAssertionFormatterFacade();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

