/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.creating;

import ch.tutteli.atrium.AtriumFactory;
import ch.tutteli.atrium.assertions.ExplanatoryAssertion;
import ch.tutteli.atrium.assertions.ExplanatoryAssertionGroup;
import ch.tutteli.atrium.assertions.IAssertion;
import ch.tutteli.atrium.assertions.IExplanatoryAssertionGroupType;
import ch.tutteli.atrium.assertions.WarningAssertionGroupType;
import ch.tutteli.atrium.creating.IAssertionPlant;
import ch.tutteli.atrium.creating.ICollectingAssertionPlant;
import ch.tutteli.atrium.creating.PlantHasNoSubjectException;
import ch.tutteli.atrium.reporting.translating.ITranslatable;
import ch.tutteli.atrium.reporting.translating.TranslatableRawString;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\n"}, d2={"Lch/tutteli/atrium/creating/AssertionCollector;", "", "()V", "doNotThrowIfNoAssertionIsCollected", "Lch/tutteli/atrium/creating/AssertionCollector$Collector;", "getDoNotThrowIfNoAssertionIsCollected", "()Lch/tutteli/atrium/creating/AssertionCollector$Collector;", "throwIfNoAssertionIsCollected", "getThrowIfNoAssertionIsCollected", "Collector", "atrium-assertions"})
public final class AssertionCollector {
    @NotNull
    private static final Collector throwIfNoAssertionIsCollected;
    @NotNull
    private static final Collector doNotThrowIfNoAssertionIsCollected;
    public static final AssertionCollector INSTANCE;

    @NotNull
    public final Collector getThrowIfNoAssertionIsCollected() {
        return throwIfNoAssertionIsCollected;
    }

    @NotNull
    public final Collector getDoNotThrowIfNoAssertionIsCollected() {
        return doNotThrowIfNoAssertionIsCollected;
    }

    private AssertionCollector() {
    }

    static {
        AssertionCollector assertionCollector;
        INSTANCE = assertionCollector = new AssertionCollector();
        throwIfNoAssertionIsCollected = new Collector(true);
        doNotThrowIfNoAssertionIsCollected = new Collector(false);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JT\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\"\b\b\u0000\u0010\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u001d\u0010\r\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u00112\b\u0010\u0012\u001a\u0004\u0018\u0001H\b\u00a2\u0006\u0002\u0010\u0013J/\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\b0\u0015\"\b\b\u0000\u0010\b*\u00020\u00012\b\u0010\u0012\u001a\u0004\u0018\u0001H\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lch/tutteli/atrium/creating/AssertionCollector$Collector;", "", "throwIfNoAssertionIsCollected", "", "(Z)V", "collectAssertionsForExplanation", "", "Lch/tutteli/atrium/assertions/IAssertion;", "E", "noSubjectMessage", "", "warning", "Lch/tutteli/atrium/reporting/translating/ITranslatable;", "assertionCreator", "Lkotlin/Function1;", "Lch/tutteli/atrium/creating/IAssertionPlant;", "", "Lkotlin/ExtensionFunctionType;", "subject", "(Ljava/lang/String;Lch/tutteli/atrium/reporting/translating/ITranslatable;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;)Ljava/util/List;", "createPlant", "Lch/tutteli/atrium/creating/ICollectingAssertionPlant;", "(Ljava/lang/Object;Ljava/lang/String;)Lch/tutteli/atrium/creating/ICollectingAssertionPlant;", "atrium-assertions"})
    public static final class Collector {
        private final boolean throwIfNoAssertionIsCollected;

        @NotNull
        public final <E> List<IAssertion> collectAssertionsForExplanation(@NotNull String noSubjectMessage, @NotNull ITranslatable warning, @NotNull Function1<? super IAssertionPlant<? extends E>, Unit> assertionCreator, @Nullable E subject) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)noSubjectMessage, (String)"noSubjectMessage");
            Intrinsics.checkParameterIsNotNull((Object)warning, (String)"warning");
            Intrinsics.checkParameterIsNotNull(assertionCreator, (String)"assertionCreator");
            try {
                boolean bl;
                ICollectingAssertionPlant<E> collectingAssertionPlant = this.createPlant(subject, noSubjectMessage);
                assertionCreator.invoke(collectingAssertionPlant);
                List collectedAssertions = collectingAssertionPlant.getAssertions();
                boolean bl2 = bl = !this.throwIfNoAssertionIsCollected || !collectedAssertions.isEmpty();
                if (!bl) {
                    String string = "There was not any assertion created which could identify an entry. Specify at least one assertion";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                list = collectedAssertions;
            }
            catch (PlantHasNoSubjectException e) {
                list = CollectionsKt.listOf((Object)new ExplanatoryAssertionGroup((IExplanatoryAssertionGroupType)WarningAssertionGroupType.INSTANCE, CollectionsKt.listOf((Object)new ExplanatoryAssertion((Object)new TranslatableRawString(warning)))));
            }
            return list;
        }

        private final <E> ICollectingAssertionPlant<E> createPlant(E subject, String noSubjectMessage) {
            return AtriumFactory.INSTANCE.newCollectingPlant(new Function0<E>(subject, noSubjectMessage){
                final /* synthetic */ Object $subject;
                final /* synthetic */ String $noSubjectMessage;

                @NotNull
                public final E invoke() {
                    Object object = this.$subject;
                    if (object == null) {
                        throw (Throwable)new PlantHasNoSubjectException(this.$noSubjectMessage);
                    }
                    return (E)object;
                }
                {
                    this.$subject = object;
                    this.$noSubjectMessage = string;
                    super(0);
                }
            });
        }

        public Collector(boolean throwIfNoAssertionIsCollected) {
            this.throwIfNoAssertionIsCollected = throwIfNoAssertionIsCollected;
        }
    }
}

