/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.oereb;

import ch.so.agi.oereb.LegendEntry;
import ch.so.agi.oereb.Qgis3SymbolTypeCodeBuilder;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OerebIconizer {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public List<LegendEntry> getSymbolsQgis3(String configFileName, String legendGraphicUrl) throws Exception {
        Qgis3SymbolTypeCodeBuilder styleConfigBuilder = new Qgis3SymbolTypeCodeBuilder(configFileName, legendGraphicUrl);
        List<LegendEntry> legendEntries = styleConfigBuilder.build();
        return legendEntries;
    }

    public void saveSymbolsToDisk(List<LegendEntry> legendEntries, String directory) throws Exception {
        for (LegendEntry entry : legendEntries) {
            String typeCode = entry.getTypeCode();
            File symbolFile = Paths.get(directory, typeCode + ".png").toFile();
            ImageIO.write((RenderedImage)entry.getSymbol(), "png", symbolFile);
        }
    }

    public int updateSymbols(List<LegendEntry> legendEntries, String jdbcUrl, String dbUsr, String dbPwd, String dbQTable, String typeCodeAttrName, String symbolAttrName, String legendTextAttrName, boolean useCommunalTypeCodes) throws Exception {
        Connection conn = this.getDbConnection(jdbcUrl, dbUsr, dbPwd);
        try {
            int count = 0;
            for (LegendEntry entry : legendEntries) {
                this.log.info("TypeCode: " + entry.getTypeCode());
                this.log.info("LegendText: " + entry.getLegendText());
                this.log.info("Symbol: " + entry.getSymbol().toString());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)entry.getSymbol(), "png", baos);
                byte[] symbolInByte = baos.toByteArray();
                String base64Encoded = Base64.getEncoder().encodeToString(symbolInByte);
                Statement stmt = conn.createStatement();
                String sql = "";
                sql = legendTextAttrName == null ? (useCommunalTypeCodes ? "UPDATE " + dbQTable + " SET " + symbolAttrName + " = decode('" + base64Encoded + "', 'base64') WHERE substring(" + typeCodeAttrName + ", 1, 3) = '" + entry.getTypeCode().substring(1, 4) + "';" : "UPDATE " + dbQTable + " SET " + symbolAttrName + " = decode('" + base64Encoded + "', 'base64') WHERE " + typeCodeAttrName + " = '" + entry.getTypeCode() + "';") : "UPDATE " + dbQTable + " SET " + symbolAttrName + " = decode('" + base64Encoded + "', 'base64'), " + legendTextAttrName + " = '" + entry.getLegendText() + "' WHERE " + typeCodeAttrName + " = '" + entry.getTypeCode() + "';";
                this.log.info(sql);
                int c = stmt.executeUpdate(sql);
                count += c;
            }
            this.log.info("Number of updated records: " + String.valueOf(count));
            conn.close();
            return count;
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            throw new Exception(e);
        }
    }

    private Connection getDbConnection(String jdbcUrl, String dbUsr, String dbPwd) {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(jdbcUrl, dbUsr, dbPwd);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
        }
        return conn;
    }
}

