/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.oereb;

import ch.so.agi.oereb.LegendEntry;
import ch.so.agi.oereb.OerebIconizer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    static Logger log = LoggerFactory.getLogger(Main.class);
    private static String dbhost;
    private static String dbdatabase;
    private static String dbport;
    private static String dbusr;
    private static String dbpwd;
    private static String sldUrl;
    private static String legendGraphicUrl;
    private static String dbQTable;
    private static String typeCodeAttrName;
    private static String symbolAttrName;
    private static String legendTextAttrName;
    private static String downloadDir;

    public static void main(String[] args) throws Exception {
        List<LegendEntry> legendEntries;
        OerebIconizer iconizer;
        for (int argi = 0; argi < args.length; ++argi) {
            String arg = args[argi];
            if (arg.equals("--dbhost")) {
                dbhost = args[++argi];
                continue;
            }
            if (arg.equals("--dbdatabase")) {
                dbdatabase = args[++argi];
                continue;
            }
            if (arg.equals("--dbport")) {
                dbport = args[++argi];
                continue;
            }
            if (arg.equals("--dbusr")) {
                dbusr = args[++argi];
                continue;
            }
            if (arg.equals("--dbpwd")) {
                dbpwd = args[++argi];
                continue;
            }
            if (arg.equals("--sldUrl")) {
                sldUrl = args[++argi];
                continue;
            }
            if (arg.equals("--legendGraphicUrl")) {
                legendGraphicUrl = args[++argi];
                continue;
            }
            if (arg.equals("--dbQTable")) {
                dbQTable = args[++argi];
                continue;
            }
            if (arg.equals("--typeCodeAttrName")) {
                typeCodeAttrName = args[++argi];
                continue;
            }
            if (arg.equals("--symbolAttrName")) {
                symbolAttrName = args[++argi];
                continue;
            }
            if (arg.equals("--legendTextAttrName")) {
                legendTextAttrName = args[++argi];
                continue;
            }
            if (arg.equals("--downloadDir")) {
                downloadDir = args[++argi];
                continue;
            }
            if (!arg.equals("--help")) continue;
            System.err.println();
            System.err.println("--dbhost                Database host.");
            System.err.println("--dbdatabase            Database name.");
            System.err.println("--dbport                Database port.");
            System.err.println("--dbusr                 Database user name.");
            System.err.println("--dbpwd                 Database user password.");
            System.err.println("--sldUrl                GetStyles request.");
            System.err.println("--legendGraphicUrl      GetLegendGraphic request incl. RULELABEL, LAYERTITLE, HEIGHT, WIDTH, SYMBOLHEIGHT, SYMBOLWIDTH and DPI parameter.");
            System.err.println("--dbQTable              Qualified table name.");
            System.err.println("--typeCodeAttrName      Name of type code attribute in table.");
            System.err.println("--symbolAttrName        Name of symbol attribute in table.");
            System.err.println("--legendTextAttrName    Name of legend text entry in table.");
            System.err.println("--downloadDir           Download directory.");
            System.err.println();
            return;
        }
        if (sldUrl == null || legendGraphicUrl == null) {
            log.error("sldUrl and legendGraphicUrl are required.");
            System.exit(2);
        }
        if (downloadDir == null) {
            if (dbhost == null || dbdatabase == null || dbport == null || dbusr == null || dbpwd == null || dbQTable == null || typeCodeAttrName == null || symbolAttrName == null) {
                log.error("Missing database, table oder attribute parameters.");
                System.exit(2);
            } else {
                iconizer = new OerebIconizer();
                legendEntries = iconizer.getSymbolsQgis3(sldUrl, legendGraphicUrl);
                String jdbcUrl = "jdbc:postgresql://" + dbhost + ":" + dbport + "/" + dbdatabase;
                iconizer.updateSymbols(legendEntries, jdbcUrl, dbusr, dbpwd, dbQTable, typeCodeAttrName, symbolAttrName, legendTextAttrName, false);
            }
        }
        if (downloadDir != null) {
            iconizer = new OerebIconizer();
            legendEntries = iconizer.getSymbolsQgis3(sldUrl, legendGraphicUrl);
            iconizer.saveSymbolsToDisk(legendEntries, downloadDir);
            return;
        }
    }

    static {
        dbport = "5432";
    }
}

