/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.oereb;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;

public class Utilities {
    public static File handleConfigInput(String configFileName) throws Exception {
        File configFile = null;
        if (configFileName.substring(0, 4).equalsIgnoreCase("http")) {
            try {
                String decodedRequest = URLDecoder.decode(configFileName, "UTF-8");
                CloseableHttpClient httpclient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
                HttpGet get = new HttpGet(new URL(decodedRequest).toURI());
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);
                Path tempDir = Files.createTempDirectory("oereb_iconizer_", new FileAttribute[0]);
                File tempFile = Paths.get(tempDir.toAbsolutePath().toFile().getAbsolutePath(), "getstyles.sld").toFile();
                InputStream source = response.getEntity().getContent();
                FileUtils.copyInputStreamToFile((InputStream)source, (File)tempFile);
                configFile = tempFile;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        } else {
            configFile = new File(configFileName);
        }
        return configFile;
    }

    public static BufferedImage getRemoteImage(String url) throws Exception {
        try {
            CloseableHttpClient httpclient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
            HttpGet get = new HttpGet(new URL(url).toURI());
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);
            InputStream inputStream = response.getEntity().getContent();
            BufferedImage image = ImageIO.read(inputStream);
            BufferedImage fixedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            Graphics2D g = (Graphics2D)fixedImage.getGraphics();
            g.setBackground(Color.WHITE);
            g.clearRect(0, 0, image.getWidth(), image.getHeight());
            g.drawImage((Image)image, 0, 0, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)fixedImage, "png", baos);
            baos.flush();
            baos.close();
            return fixedImage;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }
}

