/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.oereb;

import ch.so.agi.oereb.LegendEntry;
import ch.so.agi.oereb.Qgis3SymbolTypeCodeBuilder;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OerebIconizer {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public List<LegendEntry> getSymbolsQgis3(String configFileName, String legendGraphicUrl) throws Exception {
        Qgis3SymbolTypeCodeBuilder styleConfigBuilder = new Qgis3SymbolTypeCodeBuilder(configFileName, legendGraphicUrl);
        List<LegendEntry> legendEntries = styleConfigBuilder.build();
        return legendEntries;
    }

    public void saveSymbolsToDisk(List<LegendEntry> legendEntries, String directory) throws Exception {
        for (LegendEntry entry : legendEntries) {
            String typeCode = entry.getTypeCode();
            File symbolFile = Paths.get(directory, typeCode + ".png").toFile();
            ImageIO.write((RenderedImage)entry.getSymbol(), "png", symbolFile);
        }
    }

    public int updateSymbols(List<LegendEntry> legendEntries, String jdbcUrl, String dbUsr, String dbPwd, String dbQTable, String typeCodeAttrName, String symbolAttrName, String legendTextAttrName) throws Exception {
        Connection conn = this.getDbConnection(jdbcUrl, dbUsr, dbPwd);
        PreparedStatement pstmt = null;
        String updateSql = "UPDATE " + dbQTable + " SET " + symbolAttrName + " = ?, " + legendTextAttrName + " = ? WHERE " + typeCodeAttrName + " = ?;";
        try {
            pstmt = conn.prepareStatement(updateSql);
            for (LegendEntry entry : legendEntries) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)entry.getSymbol(), "png", baos);
                byte[] symbolInByte = baos.toByteArray();
                pstmt.setBytes(1, symbolInByte);
                pstmt.setString(2, entry.getLegendText());
                pstmt.setString(3, entry.getTypeCode());
            }
            int count = pstmt.executeUpdate();
            if (pstmt != null) {
                pstmt.close();
            }
            conn.close();
            return count;
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            throw new Exception(e);
        }
    }

    private Connection getDbConnection(String jdbcUrl, String dbUsr, String dbPwd) {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(jdbcUrl, dbUsr, dbPwd);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
        }
        return conn;
    }
}

