/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.oereb;

import ch.so.agi.oereb.SimpleNamespaceContext;
import ch.so.agi.oereb.SimpleRule;
import ch.so.agi.oereb.SymbolTypeCodeBuilder;
import ch.so.agi.oereb.Utilities;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Qgis3SymbolTypeCodeBuilder
implements SymbolTypeCodeBuilder {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private String configFileName = null;
    String legendGraphicUrl = null;

    public Qgis3SymbolTypeCodeBuilder(String configFileName, String legendGraphicUrl) {
        this.configFileName = configFileName;
        this.legendGraphicUrl = legendGraphicUrl;
    }

    @Override
    public Map<String, BufferedImage> build() throws Exception {
        HashMap<String, BufferedImage> typeCodeSymbolMap = new HashMap<String, BufferedImage>();
        File configFile = Utilities.handleConfigInput(this.configFileName);
        if (configFile == null) {
            throw new Exception("configuration file is null");
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document document = builder.parse(configFile);
        this.log.info(document.getDocumentURI());
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        HashMap<String, String> prefMap = new HashMap<String, String>(){
            {
                this.put("se", "http://www.opengis.net/se");
                this.put("ogc", "http://www.opengis.net/ogc");
            }
        };
        SimpleNamespaceContext namespaces = new SimpleNamespaceContext((Map<String, String>)prefMap);
        xpath.setNamespaceContext(namespaces);
        XPathExpression expr = xpath.compile("//se:FeatureTypeStyle/se:Rule");
        Object result = expr.evaluate(document, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        ArrayList<SimpleRule> simpleRules = new ArrayList<SimpleRule>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            SimpleRule simpleRule = this.evaluateRule(nodes.item(i));
            simpleRules.add(simpleRule);
        }
        for (SimpleRule simpleRule : simpleRules) {
            String ruleName = URLEncoder.encode(simpleRule.getRuleName(), "UTF-8");
            String requestUrl = this.legendGraphicUrl + "&RULE=" + ruleName;
            this.log.debug(requestUrl);
            BufferedImage symbol = Utilities.getRemoteImage(requestUrl);
            typeCodeSymbolMap.put(simpleRule.getTypeCodeValue(), symbol);
        }
        this.log.debug(typeCodeSymbolMap.toString());
        return typeCodeSymbolMap;
    }

    private SimpleRule evaluateRule(Node node) throws Exception {
        String ruleName = null;
        String typeCodeValue = null;
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (childNode.getLocalName() != null && childNode.getLocalName().equalsIgnoreCase("Name")) {
                ruleName = childNode.getTextContent();
            }
            if (childNode.getLocalName() == null || !childNode.getLocalName().equalsIgnoreCase("Filter")) continue;
            typeCodeValue = this.evaluateFilter(childNode);
        }
        if (ruleName == null || typeCodeValue == null) {
            throw new Exception("rule name or typecode value not found");
        }
        this.log.debug(ruleName + " " + typeCodeValue);
        return new SimpleRule(ruleName, typeCodeValue);
    }

    private String evaluateFilter(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (childNode.getLocalName() == null || !childNode.getLocalName().equalsIgnoreCase("PropertyIsEqualTo")) continue;
            NodeList filterChildNodes = childNode.getChildNodes();
            for (int j = 0; j < filterChildNodes.getLength(); ++j) {
                Node filterChildNode = filterChildNodes.item(j);
                if (filterChildNode.getLocalName() == null || !filterChildNode.getLocalName().equalsIgnoreCase("Literal")) continue;
                String typeCodeValue = filterChildNode.getTextContent();
                this.log.debug(typeCodeValue);
                return typeCodeValue;
            }
        }
        return null;
    }
}

