/*
 * Decompiled with CFR 0.152.
 */
package ch.so.agi.oereb;

import ch.so.agi.oereb.Qgis3SymbolTypeCodeBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OerebIconizer {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Map<String, BufferedImage> getSymbolsQgis3(String configFileName, String legendGraphicUrl) throws Exception {
        Qgis3SymbolTypeCodeBuilder styleConfigBuilder = new Qgis3SymbolTypeCodeBuilder(configFileName, legendGraphicUrl);
        Map<String, BufferedImage> typeCodeSymbols = styleConfigBuilder.build();
        return typeCodeSymbols;
    }

    public void saveSymbolsToDisk(Map<String, BufferedImage> typeCodeSymbols, String directory) throws Exception {
        for (String key : typeCodeSymbols.keySet()) {
            File symbolFile = Paths.get(directory, key + ".png").toFile();
            ImageIO.write((RenderedImage)typeCodeSymbols.get(key), "png", symbolFile);
        }
    }

    public void updateSymbols(Map<String, BufferedImage> typeCodeSymbols, String jdbcUrl, String dbUsr, String dbPwd, String dbQTable, String typeCodeAttrName, String symbolAttrName) throws Exception {
        Connection conn = this.getDbConnection(jdbcUrl, dbUsr, dbPwd);
        PreparedStatement pstmt = null;
        String updateSql = "UPDATE " + dbQTable + " SET " + symbolAttrName + " = ? WHERE " + typeCodeAttrName + " = ?;";
        try {
            pstmt = conn.prepareStatement(updateSql);
            for (String key : typeCodeSymbols.keySet()) {
                this.log.debug(key + " " + typeCodeSymbols.get(key));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)typeCodeSymbols.get(key), "png", baos);
                byte[] symbolInByte = baos.toByteArray();
                pstmt.setBytes(1, symbolInByte);
                pstmt.setString(2, key);
            }
            pstmt.executeUpdate();
            if (pstmt != null) {
                pstmt.close();
            }
            conn.close();
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            throw new Exception(e);
        }
    }

    private Connection getDbConnection(String jdbcUrl, String dbUsr, String dbPwd) {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(jdbcUrl, dbUsr, dbPwd);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
        }
        return conn;
    }
}

